/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service;

import de.adorsys.multibanking.domain.BankApiUser;
import de.adorsys.multibanking.domain.UserEntity;
import de.adorsys.multibanking.domain.spi.OnlineBankingService;
import de.adorsys.multibanking.exception.ResourceNotFoundException;
import de.adorsys.multibanking.pers.spi.repository.UserRepositoryIf;
import de.adorsys.multibanking.service.OnlineBankingServiceProducer;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class UserService {
    private final UserRepositoryIf userRepository;
    private final OnlineBankingServiceProducer bankingServiceProducer;

    BankApiUser checkApiRegistration(OnlineBankingService onlineBankingService, UserEntity userEntity) {
        if (onlineBankingService.userRegistrationRequired()) {
            return userEntity.getApiUser().stream().filter(bankApiUser -> bankApiUser.getBankApi() == onlineBankingService.bankApi()).findFirst().orElseGet(() -> this.registerUser(userEntity.getId(), onlineBankingService, userEntity));
        }
        BankApiUser bankApiUser2 = new BankApiUser();
        bankApiUser2.setBankApi(onlineBankingService.bankApi());
        return bankApiUser2;
    }

    private BankApiUser registerUser(String userId, OnlineBankingService onlineBankingService, UserEntity userEntity) {
        BankApiUser bankApiUser = onlineBankingService.registerUser(userId);
        userEntity.getApiUser().add(bankApiUser);
        this.userRepository.save(userEntity);
        return bankApiUser;
    }

    void checkUserExists(String userId) {
        if (!this.userRepository.exists(userId)) {
            UserEntity userEntity = new UserEntity();
            userEntity.setApiUser(new ArrayList());
            userEntity.setId(userId);
            this.userRepository.save(userEntity);
        }
    }

    UserEntity findUser(String userId) {
        return (UserEntity)this.userRepository.findById(userId).orElseThrow(() -> new ResourceNotFoundException(UserEntity.class, userId));
    }

    Optional<LocalDateTime> getRulesLastChangeDate(String userId) {
        return this.userRepository.getRulesLastChangeDate(userId);
    }

    public UserService(UserRepositoryIf userRepository, OnlineBankingServiceProducer bankingServiceProducer) {
        this.userRepository = userRepository;
        this.bankingServiceProducer = bankingServiceProducer;
    }
}

