/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.logging;

import java.lang.annotation.Annotation;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class RestControllerAspectLogging {
    private static final Logger log = LoggerFactory.getLogger(RestControllerAspectLogging.class);
    public static final Marker AUDIT_LOG = MarkerFactory.getMarker((String)"AUDIT");

    @Before(value="@annotation(io.swagger.v3.oas.annotations.Operation)")
    public void logBefore(JoinPoint joinPoint) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        log.trace(AUDIT_LOG, "Method: [{}]", (Object)request.getMethod());
        log.trace(AUDIT_LOG, "Path: [{}]", (Object)request.getServletPath());
        this.logRequestBody(joinPoint);
    }

    @AfterReturning(pointcut="@annotation(io.swagger.v3.oas.annotations.Operation)", returning="retVal")
    public void logAfterAllMethods(Object retVal) {
        log.trace(AUDIT_LOG, "Response: [{}]", (Object)retVal.toString());
    }

    private void logRequestBody(JoinPoint thisJoinPoint) {
        MethodSignature methodSignature = (MethodSignature)thisJoinPoint.getSignature();
        Annotation[][] annotationMatrix = methodSignature.getMethod().getParameterAnnotations();
        int index = -1;
        for (Annotation[] annotations : annotationMatrix) {
            ++index;
            for (Annotation annotation : annotations) {
                if (!(annotation instanceof RequestBody)) continue;
                Object requestBody = thisJoinPoint.getArgs()[index];
                log.trace(AUDIT_LOG, "Body: [{}]", (Object)requestBody.toString());
            }
        }
    }
}

