/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.web;

import de.adorsys.multibanking.domain.BankAccessEntity;
import de.adorsys.multibanking.domain.Consent;
import de.adorsys.multibanking.exception.ResourceNotFoundException;
import de.adorsys.multibanking.exception.TransactionAuthorisationRequiredException;
import de.adorsys.multibanking.pers.spi.repository.BankAccessRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.UserRepositoryIf;
import de.adorsys.multibanking.service.BankAccessService;
import de.adorsys.multibanking.service.ConsentService;
import de.adorsys.multibanking.web.BankAccountController;
import de.adorsys.multibanking.web.ConsentAuthorisationController;
import de.adorsys.multibanking.web.UserResource;
import de.adorsys.multibanking.web.mapper.BankAccessMapper;
import de.adorsys.multibanking.web.mapper.ConsentAuthorisationMapper;
import de.adorsys.multibanking.web.model.BankAccessTO;
import io.micrometer.core.annotation.Timed;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Timed(value="bank-access")
@Tag(name="Bankaccess")
@UserResource
@RestController
@RequestMapping(path={"api/v1/bankaccesses"})
public class BankAccessController {
    private static final Logger log = LoggerFactory.getLogger(BankAccessController.class);
    private final BankAccessMapper bankAccessMapper;
    private final BankAccessRepositoryIf bankAccessRepository;
    private final UserRepositoryIf userRepository;
    private final BankAccessService bankAccessService;
    private final ConsentService consentService;
    private final ConsentAuthorisationMapper consentAuthorisationMapper;
    private final Principal principal;

    @Operation(description="Create new bank access", security={@SecurityRequirement(name="multibanking_auth", scopes={"openid"})})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Created bank access", content={@Content(schema=@Schema(ref="#/components/schemas/ResourceBankAccess"))}), @ApiResponse(responseCode="202", description="Challenge response", content={@Content(schema=@Schema(ref="#/components/schemas/ResourceConsentAuthorisationResponse"))})})
    @PostMapping
    public ResponseEntity createBankAccess(@RequestBody BankAccessTO bankAccess) {
        Consent consent = this.consentService.getConsent(bankAccess.getConsentId());
        try {
            BankAccessEntity persistedBankAccess = this.bankAccessService.createBankAccess(this.bankAccessMapper.toBankAccessEntity(bankAccess, this.principal.getName(), false, consent.getPsuAccountIban()));
            return ResponseEntity.created((URI)ControllerLinkBuilder.linkTo((Object)((BankAccessController)ControllerLinkBuilder.methodOn(BankAccessController.class, (Object[])new Object[0])).getBankAccess(persistedBankAccess.getId())).toUri()).body((Object)this.mapToResource(persistedBankAccess));
        }
        catch (TransactionAuthorisationRequiredException e) {
            ArrayList<Link> links = new ArrayList<Link>();
            links.add(ControllerLinkBuilder.linkTo((Object)((ConsentAuthorisationController)ControllerLinkBuilder.methodOn(ConsentAuthorisationController.class, (Object[])new Object[0])).getConsentAuthorisationStatus(e.getConsentId(), e.getAuthorisationId())).withSelfRel());
            links.add(ControllerLinkBuilder.linkTo((Object)((ConsentAuthorisationController)ControllerLinkBuilder.methodOn(ConsentAuthorisationController.class, (Object[])new Object[0])).transactionAuthorisation(e.getConsentId(), e.getAuthorisationId(), null)).withRel("transactionAuthorisation"));
            return ResponseEntity.accepted().body((Object)new Resource((Object)this.consentAuthorisationMapper.toUpdateAuthResponseTO(e.getResponse()), links));
        }
    }

    @Operation(description="Read bank accesses", security={@SecurityRequirement(name="multibanking_auth", scopes={"openid"})})
    @GetMapping
    public Resources<Resource<BankAccessTO>> getBankAccesses() {
        if (!this.userRepository.exists(this.principal.getName())) {
            return new Resources(Collections.emptyList(), new Link[0]);
        }
        List accessEntities = this.bankAccessRepository.findByUserId(this.principal.getName());
        return new Resources((Iterable)this.mapToResources(accessEntities), new Link[0]);
    }

    @Operation(description="Read bank access", security={@SecurityRequirement(name="multibanking_auth", scopes={"openid"})})
    @GetMapping(value={"/{accessId}"})
    public Resource<BankAccessTO> getBankAccess(@PathVariable String accessId) {
        BankAccessEntity bankAccessEntity = (BankAccessEntity)this.bankAccessRepository.findByUserIdAndId(this.principal.getName(), accessId).orElseThrow(() -> new ResourceNotFoundException(BankAccessEntity.class, accessId));
        return this.mapToResource(bankAccessEntity);
    }

    @Operation(description="Update bank access", security={@SecurityRequirement(name="multibanking_auth", scopes={"openid"})})
    @PutMapping(value={"/{accessId}"})
    public HttpEntity<Void> updateBankAccess(@PathVariable String accessId, @RequestBody BankAccessTO bankAccess) {
        this.bankAccessService.updateBankAccess(accessId, this.bankAccessMapper.toBankAccessEntity(bankAccess, this.principal.getName(), false, null));
        log.info("Bank access [{}] updated.", (Object)accessId);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @Operation(description="Delete bank accesses", security={@SecurityRequirement(name="multibanking_auth", scopes={"openid"})})
    @DeleteMapping(value={"/{accessId}"})
    public HttpEntity<Void> deleteBankAccess(@PathVariable String accessId) {
        if (!this.bankAccessService.deleteBankAccess(this.principal.getName(), accessId)) {
            throw new ResourceNotFoundException(BankAccessEntity.class, accessId);
        }
        log.info("Bank Access [{}] deleted.", (Object)accessId);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    private List<Resource<BankAccessTO>> mapToResources(List<BankAccessEntity> accessEntities) {
        return accessEntities.stream().map(arg_0 -> this.mapToResource(arg_0)).collect(Collectors.toList());
    }

    private Resource<BankAccessTO> mapToResource(BankAccessEntity accessEntity) {
        return new Resource((Object)this.bankAccessMapper.toBankAccessTO(accessEntity), new Link[]{ControllerLinkBuilder.linkTo((Object)((BankAccessController)ControllerLinkBuilder.methodOn(BankAccessController.class, (Object[])new Object[0])).getBankAccess(accessEntity.getId())).withSelfRel(), ControllerLinkBuilder.linkTo((Object)((BankAccountController)ControllerLinkBuilder.methodOn(BankAccountController.class, (Object[])new Object[0])).getBankAccounts(accessEntity.getId())).withRel("accounts")});
    }

    public BankAccessController(BankAccessMapper bankAccessMapper, BankAccessRepositoryIf bankAccessRepository, UserRepositoryIf userRepository, BankAccessService bankAccessService, ConsentService consentService, ConsentAuthorisationMapper consentAuthorisationMapper, Principal principal) {
        this.bankAccessMapper = bankAccessMapper;
        this.bankAccessRepository = bankAccessRepository;
        this.userRepository = userRepository;
        this.bankAccessService = bankAccessService;
        this.consentService = consentService;
        this.consentAuthorisationMapper = consentAuthorisationMapper;
        this.principal = principal;
    }
}

