/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service;

import de.adorsys.multibanking.domain.AnonymizedBookingEntity;
import de.adorsys.multibanking.domain.BookingEntity;
import de.adorsys.multibanking.pers.spi.repository.AnonymizedBookingRepositoryIf;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
class AnonymizationService {
    private final AnonymizedBookingRepositoryIf anonymizedBookingRepository;

    @Async
    void anonymizeAndStoreBookingsAsync(List<BookingEntity> bookingEntities) {
        List uncategorizedBookings = bookingEntities.stream().filter(bookingEntity -> bookingEntity.getBookingCategory() == null && bookingEntity.getCreditorId() != null).collect(Collectors.toList());
        List anonymizedBookings = uncategorizedBookings.stream().map(arg_0 -> this.anonymizeBooking(arg_0)).collect(Collectors.toList());
        try {
            this.anonymizedBookingRepository.save(anonymizedBookings);
        }
        catch (DuplicateKeyException duplicateKeyException) {
            // empty catch block
        }
    }

    private AnonymizedBookingEntity anonymizeBooking(BookingEntity bookingEntity) {
        AnonymizedBookingEntity anonymizedBookingEntity = new AnonymizedBookingEntity();
        if (bookingEntity.getAmount().compareTo(BigDecimal.ZERO) > 0) {
            anonymizedBookingEntity.setAmount(new BigDecimal(1));
        } else {
            anonymizedBookingEntity.setAmount(new BigDecimal(-1));
        }
        anonymizedBookingEntity.setCreditorId(bookingEntity.getCreditorId());
        anonymizedBookingEntity.setPurpose(bookingEntity.getUsage());
        return anonymizedBookingEntity;
    }

    public AnonymizationService(AnonymizedBookingRepositoryIf anonymizedBookingRepository) {
        this.anonymizedBookingRepository = anonymizedBookingRepository;
    }
}

