/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service.analytics;

import de.adorsys.multibanking.exception.SmartanalyticsException;
import de.adorsys.multibanking.service.analytics.SmartAnalyticsIf;
import de.adorsys.smartanalytics.api.AnalyticsRequest;
import de.adorsys.smartanalytics.api.AnalyticsResult;
import de.adorsys.smartanalytics.api.Booking;
import de.adorsys.smartanalytics.api.Rule;
import de.adorsys.smartanalytics.api.config.ConfigStatus;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Profile;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.hateoas.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
@Profile(value={"smartanalytics-remote"})
public class SmartAnalyticsRemoteService
implements SmartAnalyticsIf {
    @Autowired
    @Qualifier(value="smartanalytics")
    private RestTemplate smartanalyticsRestTemplate;

    public AnalyticsResult analyzeBookings(List<Rule> userRules, List<Booking> bookings) {
        AnalyticsRequest analyticsRequest = this.createAnalyticsRequest(bookings, userRules);
        return this.analyzeBookingsRemote(analyticsRequest);
    }

    public ConfigStatus getAnalyticsConfigStatus() {
        ResponseEntity responseEntity = this.smartanalyticsRestTemplate.getForEntity("/status", ConfigStatus.class, new Object[0]);
        if (responseEntity.getStatusCode() == HttpStatus.OK) {
            return (ConfigStatus)responseEntity.getBody();
        }
        throw new SmartanalyticsException(responseEntity.getStatusCode(), null);
    }

    private AnalyticsResult analyzeBookingsRemote(AnalyticsRequest analyticsRequest) {
        ResponseEntity responseEntity = this.smartanalyticsRestTemplate.exchange("/api/v1/analytics", HttpMethod.PUT, new HttpEntity((Object)analyticsRequest), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, Collections.emptyMap());
        if (responseEntity.getStatusCode() == HttpStatus.OK) {
            return (AnalyticsResult)((Resource)responseEntity.getBody()).getContent();
        }
        throw new SmartanalyticsException(responseEntity.getStatusCode(), null);
    }

    private AnalyticsRequest createAnalyticsRequest(List<Booking> bookings, List<Rule> customRules) {
        return AnalyticsRequest.builder().bookings(bookings).customRules(customRules).build();
    }
}

