/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.logging;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;

public class PatternMaskingLayout
extends PatternLayout {
    private Pattern multilinePattern;
    private List<String> maskPatterns = new ArrayList();

    public void addMaskPattern(String maskPattern) {
        this.maskPatterns.add(maskPattern);
        this.multilinePattern = Pattern.compile(String.join((CharSequence)"|", this.maskPatterns), 8);
    }

    public String doLayout(ILoggingEvent event) {
        return this.maskMessage(super.doLayout(event));
    }

    private String maskMessage(String message) {
        if (this.multilinePattern == null) {
            return message;
        }
        StringBuilder sb = new StringBuilder(message);
        Matcher matcher = this.multilinePattern.matcher(sb);
        while (matcher.find()) {
            IntStream.rangeClosed(1, matcher.groupCount()).forEach(group -> {
                if (matcher.group(group) != null) {
                    IntStream.range(matcher.start(group), matcher.end(group)).forEach(i -> sb.setCharAt(i, '*'));
                }
            });
        }
        return sb.toString();
    }
}

