/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.config;

import de.adorsys.multibanking.domain.UserSecret;
import de.adorsys.multibanking.service.SecretClaimDecryptionService;
import de.adorsys.sts.filter.JWTAuthenticationFilter;
import de.adorsys.sts.token.authentication.TokenAuthenticationService;
import de.adorsys.sts.tokenauth.BearerToken;
import de.adorsys.sts.tokenauth.BearerTokenValidator;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
public class WebSecurityConfig
extends WebSecurityConfigurerAdapter {
    private static final String RULES_ADMIN_ROLE = "rules_admin";
    private final Environment environment;
    private final SecretClaimDecryptionService secretClaimDecryptionService;
    @Autowired(required=false)
    private TokenAuthenticationService tokenAuthenticationService;
    @Autowired(required=false)
    private BearerTokenValidator bearerTokenValidator;

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.csrf().disable()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).authorizeRequests().antMatchers(new String[]{"/management/health"})).permitAll().antMatchers(new String[]{"/management/info"})).permitAll().antMatchers(new String[]{"/management/**"})).hasAuthority("admin").antMatchers(new String[]{"/"})).permitAll().antMatchers(new String[]{"/pop"})).permitAll().antMatchers(new String[]{"/swagger-ui.html"})).permitAll().antMatchers(new String[]{"/webjars/**"})).permitAll().antMatchers(new String[]{"/swagger-resources/**"})).permitAll().antMatchers(new String[]{"/v2/api-docs/**"})).permitAll().antMatchers(new String[]{"/api/v1/direct/**"})).permitAll().antMatchers(new String[]{"/api/v1/consents/**"})).permitAll().antMatchers(new String[]{"/status"})).permitAll().antMatchers(HttpMethod.GET, new String[]{"/api/v1/bank/**"})).permitAll().antMatchers(HttpMethod.GET, new String[]{"/api/v1/banks/**"})).permitAll().antMatchers(HttpMethod.POST, new String[]{"/api/v1/bank/**"})).hasAuthority(RULES_ADMIN_ROLE).antMatchers(HttpMethod.POST, new String[]{"/api/v1/banks/**"})).hasAuthority(RULES_ADMIN_ROLE).antMatchers(HttpMethod.GET, new String[]{"/api/v1/images/**"})).permitAll().antMatchers(HttpMethod.POST, new String[]{"/api/v1/images/**"})).hasAuthority(RULES_ADMIN_ROLE).antMatchers(HttpMethod.GET, new String[]{"/api/v1/config/booking-categories"})).authenticated().antMatchers(new String[]{"/api/v1/config/**"})).hasAuthority(RULES_ADMIN_ROLE).antMatchers(new String[]{"/api/v1/**"})).authenticated().anyRequest()).denyAll().and()).cors();
        if (this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"sts-enable"}))) {
            http.addFilterBefore((Filter)new JWTAuthenticationFilter(this.tokenAuthenticationService), BasicAuthenticationFilter.class);
        }
    }

    @Bean
    @Scope(scopeName="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
    public BearerToken getBearerToken(HttpServletRequest request, @Autowired(required=false) BearerTokenValidator bearerTokenValidator) {
        String token = request.getHeader("Authorization");
        return bearerTokenValidator.extract(token);
    }

    @Bean
    @Scope(scopeName="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
    public Principal getPrincipal() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    @Bean
    @Primary
    @Scope(scopeName="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
    public UserSecret getRequestScopeUserSecret() {
        return new UserSecret(this.secretClaimDecryptionService.decryptSecretClaim());
    }

    @Bean
    public CorsConfigurationSource corsConfigurationSource() {
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.setAllowedOrigins(Collections.singletonList("*"));
        configuration.setAllowedMethods(Arrays.asList("HEAD", "GET", "POST", "PUT", "DELETE", "PATCH"));
        configuration.setAllowCredentials(Boolean.valueOf(true));
        configuration.setAllowedHeaders(Arrays.asList("Authorization", "Cache-Control", "Content-Type"));
        configuration.setExposedHeaders(Collections.singletonList("Location"));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", configuration);
        return source;
    }

    public WebSecurityConfig(Environment environment, SecretClaimDecryptionService secretClaimDecryptionService) {
        this.environment = environment;
        this.secretClaimDecryptionService = secretClaimDecryptionService;
    }
}

