package de.adorsys.multibanking.web.mapper;

import de.adorsys.multibanking.domain.Balance;
import de.adorsys.multibanking.domain.BalancesReport;
import de.adorsys.multibanking.domain.BankAccount.SyncStatus;
import de.adorsys.multibanking.domain.BankAccountEntity;
import de.adorsys.multibanking.domain.BankAccountType;
import de.adorsys.multibanking.web.model.BalanceTO;
import de.adorsys.multibanking.web.model.BalancesReportTO;
import de.adorsys.multibanking.web.model.BankAccountTO;
import de.adorsys.multibanking.web.model.BankAccountTO.BankAccountTypeTO;
import de.adorsys.multibanking.web.model.BankAccountTO.SyncStatusTO;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2019-10-02T14:50:02+0000",
    comments = "version: 1.3.0.Final, compiler: javac, environment: Java 1.8.0_151 (Oracle Corporation)"
)
@Component
public class BankAccountMapperImpl implements BankAccountMapper {

    @Override
    public BankAccountTO toBankAccountTO(BankAccountEntity bankAccountEntity) {
        if ( bankAccountEntity == null ) {
            return null;
        }

        BankAccountTO bankAccountTO = new BankAccountTO();

        bankAccountTO.setId( bankAccountEntity.getId() );
        bankAccountTO.setUserId( bankAccountEntity.getUserId() );
        bankAccountTO.setBankAccessId( bankAccountEntity.getBankAccessId() );
        bankAccountTO.setBalances( balancesReportToBalancesReportTO( bankAccountEntity.getBalances() ) );
        bankAccountTO.setOwner( bankAccountEntity.getOwner() );
        bankAccountTO.setCountry( bankAccountEntity.getCountry() );
        bankAccountTO.setBlz( bankAccountEntity.getBlz() );
        bankAccountTO.setBankName( bankAccountEntity.getBankName() );
        bankAccountTO.setAccountNumber( bankAccountEntity.getAccountNumber() );
        bankAccountTO.setType( bankAccountTypeToBankAccountTypeTO( bankAccountEntity.getType() ) );
        bankAccountTO.setCurrency( bankAccountEntity.getCurrency() );
        bankAccountTO.setName( bankAccountEntity.getName() );
        bankAccountTO.setBic( bankAccountEntity.getBic() );
        bankAccountTO.setIban( bankAccountEntity.getIban() );
        bankAccountTO.setSyncStatus( syncStatusToSyncStatusTO( bankAccountEntity.getSyncStatus() ) );
        bankAccountTO.setLastSync( bankAccountEntity.getLastSync() );

        return bankAccountTO;
    }

    @Override
    public List<BankAccountTO> toBankAccountTOs(List<BankAccountEntity> bankAccountEntities) {
        if ( bankAccountEntities == null ) {
            return null;
        }

        List<BankAccountTO> list = new ArrayList<BankAccountTO>( bankAccountEntities.size() );
        for ( BankAccountEntity bankAccountEntity : bankAccountEntities ) {
            list.add( toBankAccountTO( bankAccountEntity ) );
        }

        return list;
    }

    protected BalanceTO balanceToBalanceTO(Balance balance) {
        if ( balance == null ) {
            return null;
        }

        BalanceTO balanceTO = new BalanceTO();

        balanceTO.setDate( balance.getDate() );
        balanceTO.setAmount( balance.getAmount() );
        balanceTO.setCurrency( balance.getCurrency() );

        return balanceTO;
    }

    protected BalancesReportTO balancesReportToBalancesReportTO(BalancesReport balancesReport) {
        if ( balancesReport == null ) {
            return null;
        }

        BalancesReportTO balancesReportTO = new BalancesReportTO();

        balancesReportTO.setReadyBalance( balanceToBalanceTO( balancesReport.getReadyBalance() ) );
        balancesReportTO.setUnreadyBalance( balanceToBalanceTO( balancesReport.getUnreadyBalance() ) );
        balancesReportTO.setCreditBalance( balanceToBalanceTO( balancesReport.getCreditBalance() ) );
        balancesReportTO.setAvailableBalance( balanceToBalanceTO( balancesReport.getAvailableBalance() ) );
        balancesReportTO.setUsedBalance( balanceToBalanceTO( balancesReport.getUsedBalance() ) );

        return balancesReportTO;
    }

    protected BankAccountTypeTO bankAccountTypeToBankAccountTypeTO(BankAccountType bankAccountType) {
        if ( bankAccountType == null ) {
            return null;
        }

        BankAccountTypeTO bankAccountTypeTO;

        switch ( bankAccountType ) {
            case GIRO: bankAccountTypeTO = BankAccountTypeTO.GIRO;
            break;
            case SAVINGS: bankAccountTypeTO = BankAccountTypeTO.SAVINGS;
            break;
            case FIXEDTERMDEPOSIT: bankAccountTypeTO = BankAccountTypeTO.FIXEDTERMDEPOSIT;
            break;
            case DEPOT: bankAccountTypeTO = BankAccountTypeTO.DEPOT;
            break;
            case LOAN: bankAccountTypeTO = BankAccountTypeTO.LOAN;
            break;
            case CREDITCARD: bankAccountTypeTO = BankAccountTypeTO.CREDITCARD;
            break;
            case BUIILDINGSAVING: bankAccountTypeTO = BankAccountTypeTO.BUIILDINGSAVING;
            break;
            case INSURANCE: bankAccountTypeTO = BankAccountTypeTO.INSURANCE;
            break;
            case UNKNOWN: bankAccountTypeTO = BankAccountTypeTO.UNKNOWN;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + bankAccountType );
        }

        return bankAccountTypeTO;
    }

    protected SyncStatusTO syncStatusToSyncStatusTO(SyncStatus syncStatus) {
        if ( syncStatus == null ) {
            return null;
        }

        SyncStatusTO syncStatusTO;

        switch ( syncStatus ) {
            case PENDING: syncStatusTO = SyncStatusTO.PENDING;
            break;
            case SYNC: syncStatusTO = SyncStatusTO.SYNC;
            break;
            case READY: syncStatusTO = SyncStatusTO.READY;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + syncStatus );
        }

        return syncStatusTO;
    }
}
