package de.adorsys.multibanking.web.mapper;

import de.adorsys.multibanking.domain.AccountReference;
import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.Consent;
import de.adorsys.multibanking.domain.ConsentEntity;
import de.adorsys.multibanking.domain.response.CreateConsentResponse;
import de.adorsys.multibanking.web.model.AccountReferenceTO;
import de.adorsys.multibanking.web.model.ConsentTO;
import de.adorsys.multibanking.web.model.CreateConsentResponseTO;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2019-09-18T12:10:44+0000",
    comments = "version: 1.3.0.Final, compiler: javac, environment: Java 1.8.0_151 (Oracle Corporation)"
)
@Component
public class MultibankingConsentMapperImpl implements ConsentMapper {

    @Override
    public ConsentTO toConsentTO(Consent consent) {
        if ( consent == null ) {
            return null;
        }

        ConsentTO consentTO = new ConsentTO();

        consentTO.setId( consent.getConsentId() );
        consentTO.setRedirectId( consent.getRedirectId() );
        consentTO.setPsuAccountIban( consent.getPsuAccountIban() );
        consentTO.setAccounts( accountReferenceListToAccountReferenceTOList( consent.getAccounts() ) );
        consentTO.setBalances( accountReferenceListToAccountReferenceTOList( consent.getBalances() ) );
        consentTO.setTransactions( accountReferenceListToAccountReferenceTOList( consent.getTransactions() ) );
        consentTO.setRecurringIndicator( consent.isRecurringIndicator() );
        consentTO.setValidUntil( consent.getValidUntil() );
        consentTO.setFrequencyPerDay( consent.getFrequencyPerDay() );

        return consentTO;
    }

    @Override
    public Consent toConsent(ConsentTO consent) {
        if ( consent == null ) {
            return null;
        }

        Consent consent1 = new Consent();

        consent1.setRedirectId( consent.getRedirectId() );
        consent1.setPsuAccountIban( consent.getPsuAccountIban() );
        consent1.setAccounts( accountReferenceTOListToAccountReferenceList( consent.getAccounts() ) );
        consent1.setBalances( accountReferenceTOListToAccountReferenceList( consent.getBalances() ) );
        consent1.setTransactions( accountReferenceTOListToAccountReferenceList( consent.getTransactions() ) );
        consent1.setRecurringIndicator( consent.isRecurringIndicator() );
        consent1.setValidUntil( consent.getValidUntil() );
        consent1.setFrequencyPerDay( consent.getFrequencyPerDay() );

        return consent1;
    }

    @Override
    public Consent toConsent(ConsentEntity consent) {
        if ( consent == null ) {
            return null;
        }

        Consent consent1 = new Consent();

        consent1.setConsentId( consent.getId() );
        consent1.setRedirectId( consent.getRedirectId() );
        consent1.setPsuAccountIban( consent.getPsuAccountIban() );

        return consent1;
    }

    @Override
    public CreateConsentResponseTO toCreateConsentResponseTO(CreateConsentResponse createConsentResponse) {
        if ( createConsentResponse == null ) {
            return null;
        }

        CreateConsentResponseTO createConsentResponseTO = new CreateConsentResponseTO();

        createConsentResponseTO.setConsentId( createConsentResponse.getConsentId() );
        createConsentResponseTO.setAuthorisationId( createConsentResponse.getAuthorisationId() );

        return createConsentResponseTO;
    }

    @Override
    public ConsentEntity toConsentEntity(CreateConsentResponse createConsentResponse, String redirectId, String psuAccountIban, BankApi bankApi) {
        if ( createConsentResponse == null && redirectId == null && psuAccountIban == null && bankApi == null ) {
            return null;
        }

        ConsentEntity consentEntity = new ConsentEntity();

        if ( createConsentResponse != null ) {
            consentEntity.setAuthorisationId( createConsentResponse.getAuthorisationId() );
            consentEntity.setBankApiConsentData( createConsentResponse.getBankApiConsentData() );
            consentEntity.setId( createConsentResponse.getConsentId() );
            consentEntity.setRedirectId( createConsentResponse.getRedirectId() );
        }
        if ( psuAccountIban != null ) {
            consentEntity.setPsuAccountIban( psuAccountIban );
        }
        if ( bankApi != null ) {
            consentEntity.setBankApi( bankApi );
        }

        return consentEntity;
    }

    protected AccountReferenceTO accountReferenceToAccountReferenceTO(AccountReference accountReference) {
        if ( accountReference == null ) {
            return null;
        }

        AccountReferenceTO accountReferenceTO = new AccountReferenceTO();

        accountReferenceTO.setIban( accountReference.getIban() );
        accountReferenceTO.setCurrency( accountReference.getCurrency() );

        return accountReferenceTO;
    }

    protected List<AccountReferenceTO> accountReferenceListToAccountReferenceTOList(List<AccountReference> list) {
        if ( list == null ) {
            return null;
        }

        List<AccountReferenceTO> list1 = new ArrayList<AccountReferenceTO>( list.size() );
        for ( AccountReference accountReference : list ) {
            list1.add( accountReferenceToAccountReferenceTO( accountReference ) );
        }

        return list1;
    }

    protected AccountReference accountReferenceTOToAccountReference(AccountReferenceTO accountReferenceTO) {
        if ( accountReferenceTO == null ) {
            return null;
        }

        AccountReference accountReference = new AccountReference();

        accountReference.setIban( accountReferenceTO.getIban() );
        accountReference.setCurrency( accountReferenceTO.getCurrency() );

        return accountReference;
    }

    protected List<AccountReference> accountReferenceTOListToAccountReferenceList(List<AccountReferenceTO> list) {
        if ( list == null ) {
            return null;
        }

        List<AccountReference> list1 = new ArrayList<AccountReference>( list.size() );
        for ( AccountReferenceTO accountReferenceTO : list ) {
            list1.add( accountReferenceTOToAccountReference( accountReferenceTO ) );
        }

        return list1;
    }
}
