/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.web;

import de.adorsys.multibanking.domain.BankAccessEntity;
import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.BankAccountEntity;
import de.adorsys.multibanking.domain.StandingOrderEntity;
import de.adorsys.multibanking.exception.ResourceNotFoundException;
import de.adorsys.multibanking.exception.SyncInProgressException;
import de.adorsys.multibanking.pers.spi.repository.BankAccessRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.BankAccountRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.StandingOrderRepositoryIf;
import de.adorsys.multibanking.web.UserResource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.security.Principal;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Multibanking standing order"})
@UserResource
@RestController
@RequestMapping(path={"api/v1/bankaccesses/{accessId}/accounts/{accountId}/standingorders"})
public class StandingOrderController {
    private final StandingOrderRepositoryIf standingOrderRepository;
    private final BankAccessRepositoryIf bankAccessRepository;
    private final BankAccountRepositoryIf bankAccountRepository;
    private final Principal principal;

    @ApiOperation(value="Read account standing orders", authorizations={@Authorization(value="multibanking_auth", scopes={@AuthorizationScope(scope="openid", description="")})})
    @GetMapping
    public Resources<StandingOrderEntity> getStandingOrders(@PathVariable String accessId, @PathVariable String accountId) {
        if (!this.bankAccessRepository.exists(accessId)) {
            throw new ResourceNotFoundException(BankAccessEntity.class, accessId);
        }
        if (!this.bankAccountRepository.exists(accountId)) {
            throw new ResourceNotFoundException(BankAccountEntity.class, accountId);
        }
        if (this.bankAccountRepository.getSyncStatus(accountId) == BankAccount.SyncStatus.SYNC) {
            throw new SyncInProgressException(accountId);
        }
        return new Resources((Iterable)this.standingOrderRepository.findByUserIdAndAccountId(this.principal.getName(), accountId), new Link[]{ControllerLinkBuilder.linkTo((Object)((StandingOrderController)ControllerLinkBuilder.methodOn(StandingOrderController.class, (Object[])new Object[0])).getStandingOrders(accessId, accountId)).withSelfRel()});
    }

    public StandingOrderController(StandingOrderRepositoryIf standingOrderRepository, BankAccessRepositoryIf bankAccessRepository, BankAccountRepositoryIf bankAccountRepository, Principal principal) {
        this.standingOrderRepository = standingOrderRepository;
        this.bankAccessRepository = bankAccessRepository;
        this.bankAccountRepository = bankAccountRepository;
        this.principal = principal;
    }
}

