/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.web;

import de.adorsys.multibanking.domain.BankAccessEntity;
import de.adorsys.multibanking.domain.BankAccountEntity;
import de.adorsys.multibanking.domain.BankEntity;
import de.adorsys.multibanking.domain.BookingEntity;
import de.adorsys.multibanking.domain.ConsentEntity;
import de.adorsys.multibanking.domain.ScaStatus;
import de.adorsys.multibanking.domain.UserEntity;
import de.adorsys.multibanking.domain.response.UpdateAuthResponse;
import de.adorsys.multibanking.exception.ResourceNotFoundException;
import de.adorsys.multibanking.exception.TransactionAuthorisationRequiredException;
import de.adorsys.multibanking.pers.spi.repository.BankAccessRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.BankAccountRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.UserRepositoryIf;
import de.adorsys.multibanking.service.BankAccountService;
import de.adorsys.multibanking.service.BankService;
import de.adorsys.multibanking.service.BookingService;
import de.adorsys.multibanking.service.ConsentService;
import de.adorsys.multibanking.web.ConsentAuthorisationController;
import de.adorsys.multibanking.web.DirectAccessController;
import de.adorsys.multibanking.web.UserResource;
import de.adorsys.multibanking.web.mapper.BalancesMapper;
import de.adorsys.multibanking.web.mapper.BankAccessMapper;
import de.adorsys.multibanking.web.mapper.BankAccountMapper;
import de.adorsys.multibanking.web.mapper.BankApiMapper;
import de.adorsys.multibanking.web.mapper.BookingMapper;
import de.adorsys.multibanking.web.mapper.ConsentAuthorisationMapper;
import de.adorsys.multibanking.web.model.BankAccessTO;
import de.adorsys.multibanking.web.model.BankAccountTO;
import de.adorsys.multibanking.web.model.BankApiTO;
import de.adorsys.multibanking.web.model.UpdateAuthResponseTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Multibanking direct access"})
@UserResource
@RestController
@RequestMapping(path={"api/v1/direct"})
public class DirectAccessController {
    private static final Logger log = LoggerFactory.getLogger(DirectAccessController.class);
    private final BookingMapper bookingMapper;
    private final BankApiMapper bankApiMapper;
    private final BalancesMapper balancesMapper;
    private final BankAccessMapper bankAccessMapper;
    private final BankAccountMapper bankAccountMapper;
    private final BankAccountService bankAccountService;
    private final BankService bankService;
    private final BookingService bookingService;
    private final BankAccessRepositoryIf bankAccessRepository;
    private final BankAccountRepositoryIf bankAccountRepository;
    private final UserRepositoryIf userRepository;
    private final ConsentService consentService;
    private final ConsentAuthorisationMapper consentAuthorisationMapper;
    @Value(value="${threshold_temporaryData:15}")
    private Integer thresholdTemporaryData;

    @ApiOperation(value="create challenge for accounts")
    @ApiResponses(value={@ApiResponse(code=200, message="Response", response=UpdateAuthResponseTO.class)})
    @PostMapping(value={"/accounts"})
    public ResponseEntity createHbciAccountsChallenge(@Valid @RequestBody LoadAccountsRequest loadAccountsRequest, @RequestParam(required=false) BankApiTO bankApi) {
        try {
            return this.doLoadBankAccounts(loadAccountsRequest, bankApi, ScaStatus.SCAMETHODSELECTED);
        }
        catch (TransactionAuthorisationRequiredException e) {
            log.debug("process finished < return challenge");
            return this.createChallengeResponse(e.getResponse(), e.getConsentId(), e.getAuthorisationId());
        }
    }

    @ApiOperation(value="Read bank accounts")
    @ApiResponses(value={@ApiResponse(code=200, message="Response", response=UpdateAuthResponseTO.class)})
    @PutMapping(value={"/accounts"})
    public ResponseEntity loadBankAccounts(@Valid @RequestBody LoadAccountsRequest loadAccountsRequest, @RequestParam(required=false) BankApiTO bankApi) {
        return this.doLoadBankAccounts(loadAccountsRequest, bankApi, ScaStatus.FINALISED);
    }

    @ApiOperation(value="create challenge for bookings")
    @ApiResponses(value={@ApiResponse(code=200, message="Response", response=LoadBookingsResponse.class)})
    @PostMapping(value={"/bookings"})
    public ResponseEntity createHbciBookingsChallenge(@Valid @RequestBody LoadBookingsRequest loadBookingsRequest, @RequestParam(required=false) BankApiTO bankApi) {
        try {
            return this.doLoadBookings(loadBookingsRequest, bankApi, ScaStatus.SCAMETHODSELECTED);
        }
        catch (TransactionAuthorisationRequiredException e) {
            log.debug("process finished < return challenge");
            return this.createChallengeResponse(e.getResponse(), e.getConsentId(), e.getAuthorisationId());
        }
    }

    @ApiResponses(value={@ApiResponse(code=200, message="Response", response=LoadBookingsResponse.class)})
    @ApiOperation(value="Read account bookings")
    @PutMapping(value={"/bookings"})
    public ResponseEntity loadBookings(@Valid @RequestBody LoadBookingsRequest loadBookingsRequest, @RequestParam(required=false) BankApiTO bankApi) {
        return this.doLoadBookings(loadBookingsRequest, bankApi, ScaStatus.FINALISED);
    }

    private ResponseEntity doLoadBankAccounts(LoadAccountsRequest loadAccountsRequest, BankApiTO bankApi, ScaStatus scaStatus) {
        UserEntity userEntity = this.createTemporaryUser();
        BankAccessEntity bankAccessEntity = this.prepareBankAccess(loadAccountsRequest.getBankAccess(), userEntity);
        BankEntity bankEntity = this.bankService.findBank(bankAccessEntity.getBankCode());
        log.debug("load bank account list from bank");
        List bankAccounts = this.bankAccountService.loadBankAccountsOnline(bankEntity, bankAccessEntity, userEntity, this.bankApiMapper.toBankApi(bankApi), scaStatus);
        log.debug("save bank account list to db");
        bankAccounts.forEach(account -> {
            account.setUserId(userEntity.getId());
            account.setBankAccessId(bankAccessEntity.getId());
            this.bankAccountRepository.save(account);
        });
        return this.createLoadBankAccountsResponse(bankAccounts);
    }

    private ResponseEntity doLoadBookings(LoadBookingsRequest loadBookingsRequest, BankApiTO bankApi, ScaStatus scaStatus) {
        log.debug("process start > load booking list");
        BankAccessEntity bankAccessEntity = this.getBankAccessEntity(loadBookingsRequest);
        BankAccountEntity bankAccountEntity = this.getBankAccountEntity(loadBookingsRequest, bankAccessEntity);
        log.debug("load booking list from bank");
        List bookingEntities = this.bookingService.syncBookings(scaStatus, bankAccessEntity, bankAccountEntity, this.bankApiMapper.toBankApi(bankApi));
        return this.createLoadBookingsResponse(bankAccountEntity, bookingEntities);
    }

    private BankAccessEntity getBankAccessEntity(LoadBookingsRequest loadBookingsRequest) {
        return Optional.ofNullable(loadBookingsRequest.getUserId()).map(userId -> (BankAccessEntity)this.bankAccessRepository.findByUserIdAndId(loadBookingsRequest.getUserId(), loadBookingsRequest.getAccessId()).orElseThrow(() -> new ResourceNotFoundException(BankAccessTO.class, loadBookingsRequest.getAccessId()))).orElseGet(() -> this.prepareBankAccess(loadBookingsRequest.getBankAccess()));
    }

    private BankAccountEntity getBankAccountEntity(LoadBookingsRequest loadBookingsRequest, BankAccessEntity bankAccessEntity) {
        return Optional.ofNullable(loadBookingsRequest.getAccountId()).map(accountId -> (BankAccountEntity)this.bankAccountRepository.findByUserIdAndId(loadBookingsRequest.getUserId(), loadBookingsRequest.getAccountId()).orElseThrow(() -> new ResourceNotFoundException(BankAccountTO.class, loadBookingsRequest.getAccountId()))).orElseGet(() -> {
            BankAccountEntity bankAccountEntity = new BankAccountEntity();
            bankAccountEntity.setBankAccessId(bankAccessEntity.getId());
            bankAccountEntity.setUserId(bankAccessEntity.getUserId());
            bankAccountEntity.setIban(bankAccessEntity.getIban());
            return bankAccountEntity;
        });
    }

    private BankAccessEntity prepareBankAccess(BankAccessTO bankAccess) {
        return this.prepareBankAccess(bankAccess, null);
    }

    private BankAccessEntity prepareBankAccess(BankAccessTO bankAccess, UserEntity userEntity) {
        log.debug("save temporary user to db");
        userEntity = Optional.ofNullable(userEntity).orElseGet(() -> this.createTemporaryUser());
        this.userRepository.save(userEntity);
        ConsentEntity internalConsent = this.consentService.getInternalConsent(bankAccess.getConsentId());
        BankAccessEntity bankAccessEntity = this.bankAccessMapper.toBankAccessEntity(bankAccess, userEntity.getId(), true, internalConsent.getPsuAccountIban());
        bankAccessEntity.setUserId(userEntity.getId());
        this.bankAccessRepository.save(bankAccessEntity);
        return bankAccessEntity;
    }

    private UserEntity createTemporaryUser() {
        UserEntity userEntity = new UserEntity();
        userEntity.setId(UUID.randomUUID().toString());
        userEntity.setExpireUser(LocalDateTime.now().plusMinutes(this.thresholdTemporaryData.intValue()));
        return userEntity;
    }

    private ResponseEntity<LoadBankAccountsResponse> createLoadBankAccountsResponse(List<BankAccountEntity> bankAccounts) {
        LoadBankAccountsResponse response = new LoadBankAccountsResponse();
        response.setBankAccounts(this.bankAccountMapper.toBankAccountTOs(bankAccounts));
        log.debug("process finished < return bank account list");
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    private ResponseEntity<LoadBookingsResponse> createLoadBookingsResponse(BankAccountEntity bankAccountEntity, List<BookingEntity> bookings) {
        LoadBookingsResponse loadBookingsResponse = new LoadBookingsResponse();
        loadBookingsResponse.setBookings(this.bookingMapper.toBookingTOs(bookings));
        loadBookingsResponse.setBalances(this.balancesMapper.toBalancesReportTO(bankAccountEntity.getBalances()));
        log.debug("process finished < return booking list");
        return new ResponseEntity((Object)loadBookingsResponse, HttpStatus.OK);
    }

    private ResponseEntity<Resource<UpdateAuthResponseTO>> createChallengeResponse(UpdateAuthResponse response, String consentId, String authorisationId) {
        ArrayList<Link> links = new ArrayList<Link>();
        links.add(ControllerLinkBuilder.linkTo((Object)((ConsentAuthorisationController)ControllerLinkBuilder.methodOn(ConsentAuthorisationController.class, (Object[])new Object[0])).getConsentAuthorisationStatus(consentId, authorisationId)).withSelfRel());
        links.add(ControllerLinkBuilder.linkTo((Object)((ConsentAuthorisationController)ControllerLinkBuilder.methodOn(ConsentAuthorisationController.class, (Object[])new Object[0])).transactionAuthorisation(consentId, authorisationId, null)).withRel("transactionAuthorisation"));
        return ResponseEntity.ok((Object)new Resource((Object)this.consentAuthorisationMapper.toUpdateAuthResponseTO(response), links));
    }

    public DirectAccessController(BookingMapper bookingMapper, BankApiMapper bankApiMapper, BalancesMapper balancesMapper, BankAccessMapper bankAccessMapper, BankAccountMapper bankAccountMapper, BankAccountService bankAccountService, BankService bankService, BookingService bookingService, BankAccessRepositoryIf bankAccessRepository, BankAccountRepositoryIf bankAccountRepository, UserRepositoryIf userRepository, ConsentService consentService, ConsentAuthorisationMapper consentAuthorisationMapper) {
        this.bookingMapper = bookingMapper;
        this.bankApiMapper = bankApiMapper;
        this.balancesMapper = balancesMapper;
        this.bankAccessMapper = bankAccessMapper;
        this.bankAccountMapper = bankAccountMapper;
        this.bankAccountService = bankAccountService;
        this.bankService = bankService;
        this.bookingService = bookingService;
        this.bankAccessRepository = bankAccessRepository;
        this.bankAccountRepository = bankAccountRepository;
        this.userRepository = userRepository;
        this.consentService = consentService;
        this.consentAuthorisationMapper = consentAuthorisationMapper;
    }
}

