/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.web;

import de.adorsys.multibanking.domain.BankAccessEntity;
import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.BankAccountEntity;
import de.adorsys.multibanking.domain.BookingEntity;
import de.adorsys.multibanking.domain.BookingsIndexEntity;
import de.adorsys.multibanking.exception.ResourceNotFoundException;
import de.adorsys.multibanking.exception.SyncInProgressException;
import de.adorsys.multibanking.pers.spi.repository.BankAccessRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.BankAccountRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.BookingRepositoryIf;
import de.adorsys.multibanking.service.BookingService;
import de.adorsys.multibanking.web.UserResource;
import de.adorsys.multibanking.web.mapper.BankApiMapper;
import de.adorsys.multibanking.web.mapper.BookingMapper;
import de.adorsys.multibanking.web.model.BankApiTO;
import de.adorsys.multibanking.web.model.BookingTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.security.Principal;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Multibanking booking"})
@UserResource
@RestController
@RequestMapping(path={"api/v1/bankaccesses/{accessId}/accounts/{accountId}/bookings"})
public class BookingController {
    private final BookingMapper bookingMapper;
    private final BankApiMapper bankApiMapper;
    private final BookingService bookingService;
    private final BookingRepositoryIf bookingRepository;
    private final BankAccessRepositoryIf bankAccessRepository;
    private final BankAccountRepositoryIf bankAccountRepository;
    private final Principal principal;

    @ApiOperation(value="Read account bookings", authorizations={@Authorization(value="multibanking_auth", scopes={@AuthorizationScope(scope="openid", description="")})})
    @GetMapping
    public Resources<BookingTO> getBookings(@PathVariable String accessId, @PathVariable String accountId, @RequestParam(required=false) BankApiTO bankApi, @RequestParam(required=false) List<String> ids, @PageableDefault(size=20, sort={"valutaDate"}, direction=Sort.Direction.DESC) Pageable pageable, PagedResourcesAssembler assembler) {
        this.chackBankAccountExists(accessId, accountId);
        if (this.bankAccountRepository.getSyncStatus(accountId) == BankAccount.SyncStatus.SYNC) {
            throw new SyncInProgressException(accountId);
        }
        return Optional.ofNullable(ids).map(strings -> {
            Iterable bookingEntities = this.bookingService.getBookingsById(this.principal.getName(), ids);
            return new Resources((Iterable)this.bookingMapper.toBookingTOs(bookingEntities), new Link[0]);
        }).orElseGet(() -> {
            Page bookingEntities = this.bookingService.getBookingsPageable(pageable, this.principal.getName(), accessId, accountId, this.bankApiMapper.toBankApi(bankApi));
            return assembler.toResource(bookingEntities.map(arg_0 -> ((BookingMapper)this.bookingMapper).toBookingTO(arg_0)));
        });
    }

    @ApiOperation(value="Read account bookings search index", authorizations={@Authorization(value="multibanking_auth", scopes={@AuthorizationScope(scope="openid", description="")})})
    @GetMapping(value={"/index"})
    public Resource<BookingsIndexEntity> getBookingsIndex(@PathVariable String accessId, @PathVariable String accountId) {
        this.chackBankAccountExists(accessId, accountId);
        if (this.bankAccountRepository.getSyncStatus(accountId) == BankAccount.SyncStatus.SYNC) {
            throw new SyncInProgressException(accountId);
        }
        BookingsIndexEntity bookingsIndexEntity = (BookingsIndexEntity)this.bookingService.getSearchIndex(this.principal.getName(), accountId).orElseThrow(() -> new ResourceNotFoundException(BookingsIndexEntity.class, accountId));
        return new Resource((Object)bookingsIndexEntity, new Link[0]);
    }

    @ApiOperation(value="Download bookings", authorizations={@Authorization(value="multibanking_auth", scopes={@AuthorizationScope(scope="openid", description="")})})
    @GetMapping(path={"/download"}, produces={"application/octet-stream"})
    public HttpEntity<String> downloadBookings(@PathVariable String accessId, @PathVariable String accountId) {
        this.chackBankAccountExists(accessId, accountId);
        String bookingsAsCSV = this.bookingService.getBookingsCsv(this.principal.getName(), accessId, accountId);
        return ResponseEntity.ok().body((Object)bookingsAsCSV);
    }

    @ApiOperation(value="Read booking", authorizations={@Authorization(value="multibanking_auth", scopes={@AuthorizationScope(scope="openid", description="")})})
    @GetMapping(value={"/{bookingId}"})
    public Resource<BookingTO> getBooking(@PathVariable String accessId, @PathVariable String accountId, @PathVariable String bookingId) {
        this.chackBankAccountExists(accessId, accountId);
        BookingEntity bookingEntity = (BookingEntity)this.bookingRepository.findByUserIdAndId(this.principal.getName(), bookingId).orElseThrow(() -> new ResourceNotFoundException(BookingEntity.class, bookingId));
        return this.mapToResource(bookingEntity, accessId, accountId);
    }

    private void chackBankAccountExists(String accessId, String accountId) {
        if (!this.bankAccessRepository.exists(accessId)) {
            throw new ResourceNotFoundException(BankAccessEntity.class, accessId);
        }
        if (!this.bankAccountRepository.exists(accountId)) {
            throw new ResourceNotFoundException(BankAccountEntity.class, accountId);
        }
    }

    private Resource<BookingTO> mapToResource(BookingEntity entity, String accessId, String accountId) {
        return new Resource((Object)this.bookingMapper.toBookingTO(entity), new Link[]{ControllerLinkBuilder.linkTo((Object)((BookingController)ControllerLinkBuilder.methodOn(BookingController.class, (Object[])new Object[0])).getBooking(accessId, accountId, entity.getId())).withSelfRel()});
    }

    public BookingController(BookingMapper bookingMapper, BankApiMapper bankApiMapper, BookingService bookingService, BookingRepositoryIf bookingRepository, BankAccessRepositoryIf bankAccessRepository, BankAccountRepositoryIf bankAccountRepository, Principal principal) {
        this.bookingMapper = bookingMapper;
        this.bankApiMapper = bankApiMapper;
        this.bookingService = bookingService;
        this.bookingRepository = bookingRepository;
        this.bankAccessRepository = bankAccessRepository;
        this.bankAccountRepository = bankAccountRepository;
        this.principal = principal;
    }
}

