/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service;

import de.adorsys.multibanking.bg.BankingGatewayAdapter;
import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.BankEntity;
import de.adorsys.multibanking.domain.spi.OnlineBankingService;
import de.adorsys.multibanking.figo.FigoBanking;
import de.adorsys.multibanking.finapi.FinapiBanking;
import de.adorsys.multibanking.hbci.Hbci4JavaBanking;
import de.adorsys.multibanking.pers.spi.repository.BankRepositoryIf;
import de.adorsys.multibanking.service.OnlineBankingServiceProducer;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OnlineBankingServiceProducer {
    private final BankRepositoryIf bankRepository;
    @Value(value="${defaultBankApi:HBCI}")
    private String defaultBankApi;
    @Value(value="${bankinggateway.b2c.url}")
    private String bankingGatewayBaseUrl;
    @Value(value="${bankinggateway.adapter.url}")
    private String bankingAdapterBaseUrl;
    private final AtomicReference<Object> xs2ABanking = new AtomicReference();
    private Hbci4JavaBanking hbci4JavaBanking = new Hbci4JavaBanking(true);
    private FigoBanking figoBanking = new FigoBanking(BankApi.FIGO);
    private FigoBanking figoBankingAlternative = new FigoBanking(BankApi.FIGO_ALTERNATIVE);
    private FinapiBanking finapiBanking = new FinapiBanking();

    private BankApi getBankApiForBlz(String blz) {
        BankEntity bankInfoEntity = this.bankRepository.findByBankCode(blz).orElse(null);
        if (bankInfoEntity != null && bankInfoEntity.getBankApi() != null) {
            return bankInfoEntity.getBankApi();
        }
        return BankApi.valueOf((String)this.defaultBankApi);
    }

    public OnlineBankingService getBankingService(String bankCode) {
        BankApi bankApi = this.getBankApiForBlz(bankCode);
        return this.getBankingService(bankApi);
    }

    public OnlineBankingService getBankingService(BankApi bankApi) {
        switch (1.$SwitchMap$de$adorsys$multibanking$domain$BankApi[bankApi.ordinal()]) {
            case 1: {
                return this.hbci4JavaBanking;
            }
            case 2: {
                return this.figoBanking;
            }
            case 3: {
                return this.figoBankingAlternative;
            }
            case 4: {
                return this.finapiBanking;
            }
            case 5: {
                return this.getXs2ABanking();
            }
        }
        throw new IllegalStateException("unsupported bank api");
    }

    public OnlineBankingServiceProducer(BankRepositoryIf bankRepository) {
        this.bankRepository = bankRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BankingGatewayAdapter getXs2ABanking() {
        Object value = this.xs2ABanking.get();
        if (value == null) {
            AtomicReference atomicReference = this.xs2ABanking;
            synchronized (atomicReference) {
                value = this.xs2ABanking.get();
                if (value == null) {
                    BankingGatewayAdapter actualValue = new BankingGatewayAdapter(this.bankingGatewayBaseUrl, this.bankingAdapterBaseUrl);
                    value = actualValue == null ? this.xs2ABanking : actualValue;
                    this.xs2ABanking.set(value);
                }
            }
        }
        return value == this.xs2ABanking ? null : value;
    }
}

