/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.web.mapper;

import de.adorsys.multibanking.domain.AuthenticationType;
import de.adorsys.multibanking.domain.Bank;
import de.adorsys.multibanking.domain.BankEntity;
import de.adorsys.multibanking.domain.ChallengeData;
import de.adorsys.multibanking.domain.ConsentEntity;
import de.adorsys.multibanking.domain.Credentials;
import de.adorsys.multibanking.domain.ScaApproach;
import de.adorsys.multibanking.domain.ScaStatus;
import de.adorsys.multibanking.domain.TanTransportType;
import de.adorsys.multibanking.domain.request.SelectPsuAuthenticationMethodRequest;
import de.adorsys.multibanking.domain.request.TransactionAuthorisationRequest;
import de.adorsys.multibanking.domain.request.UpdatePsuAuthenticationRequest;
import de.adorsys.multibanking.domain.response.UpdateAuthResponse;
import de.adorsys.multibanking.web.mapper.ConsentAuthorisationMapper;
import de.adorsys.multibanking.web.mapper.ConsentAuthorisationMapperImpl;
import de.adorsys.multibanking.web.model.AuthenticationTypeTO;
import de.adorsys.multibanking.web.model.ChallengeDataTO;
import de.adorsys.multibanking.web.model.ScaApproachTO;
import de.adorsys.multibanking.web.model.ScaStatusTO;
import de.adorsys.multibanking.web.model.SelectPsuAuthenticationMethodRequestTO;
import de.adorsys.multibanking.web.model.TanTransportTypeTO;
import de.adorsys.multibanking.web.model.TransactionAuthorisationRequestTO;
import de.adorsys.multibanking.web.model.UpdateAuthResponseTO;
import de.adorsys.multibanking.web.model.UpdatePsuAuthenticationRequestTO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ConsentAuthorisationMapperImpl
implements ConsentAuthorisationMapper {
    public UpdatePsuAuthenticationRequest toUpdatePsuAuthenticationRequest(UpdatePsuAuthenticationRequestTO updatePsuAuthenticationRequest, ConsentEntity consentEntity, BankEntity bank) {
        if (updatePsuAuthenticationRequest == null && consentEntity == null && bank == null) {
            return null;
        }
        UpdatePsuAuthenticationRequest updatePsuAuthenticationRequest1 = new UpdatePsuAuthenticationRequest();
        if (updatePsuAuthenticationRequest != null) {
            updatePsuAuthenticationRequest1.setCredentials(this.updatePsuAuthenticationRequestTOToCredentials(updatePsuAuthenticationRequest));
        }
        if (consentEntity != null) {
            updatePsuAuthenticationRequest1.setAuthorisationId(consentEntity.getAuthorisationId());
            updatePsuAuthenticationRequest1.setBankApiConsentData(consentEntity.getBankApiConsentData());
            updatePsuAuthenticationRequest1.setConsentId(consentEntity.getId());
            updatePsuAuthenticationRequest1.setPsuAccountIban(consentEntity.getPsuAccountIban());
        }
        if (bank != null) {
            updatePsuAuthenticationRequest1.setBank((Bank)bank);
        }
        return updatePsuAuthenticationRequest1;
    }

    public UpdateAuthResponseTO toUpdateAuthResponseTO(UpdateAuthResponse updateAuthResponse) {
        if (updateAuthResponse == null) {
            return null;
        }
        UpdateAuthResponseTO updateAuthResponseTO = new UpdateAuthResponseTO();
        updateAuthResponseTO.setScaMethods(this.tanTransportTypeListToTanTransportTypeTOList(updateAuthResponse.getScaMethods()));
        updateAuthResponseTO.setScaStatus(this.scaStatusToScaStatusTO(updateAuthResponse.getScaStatus()));
        updateAuthResponseTO.setChallenge(this.challengeDataToChallengeDataTO(updateAuthResponse.getChallenge()));
        updateAuthResponseTO.setPsuMessage(updateAuthResponse.getPsuMessage());
        updateAuthResponseTO.setScaApproach(this.scaApproachToScaApproachTO(updateAuthResponse.getScaApproach()));
        return updateAuthResponseTO;
    }

    public SelectPsuAuthenticationMethodRequest toSelectPsuAuthenticationMethodRequest(SelectPsuAuthenticationMethodRequestTO selectPsuAuthenticationMethodRequest, ConsentEntity consentEntity) {
        if (selectPsuAuthenticationMethodRequest == null && consentEntity == null) {
            return null;
        }
        SelectPsuAuthenticationMethodRequest selectPsuAuthenticationMethodRequest1 = new SelectPsuAuthenticationMethodRequest();
        if (selectPsuAuthenticationMethodRequest != null) {
            selectPsuAuthenticationMethodRequest1.setAuthenticationMethodId(selectPsuAuthenticationMethodRequest.getAuthenticationMethodId());
        }
        if (consentEntity != null) {
            selectPsuAuthenticationMethodRequest1.setConsentId(consentEntity.getId());
            selectPsuAuthenticationMethodRequest1.setBankApiConsentData(consentEntity.getBankApiConsentData());
            selectPsuAuthenticationMethodRequest1.setAuthorisationId(consentEntity.getAuthorisationId());
            selectPsuAuthenticationMethodRequest1.setPsuAccountIban(consentEntity.getPsuAccountIban());
        }
        return selectPsuAuthenticationMethodRequest1;
    }

    public TransactionAuthorisationRequest toTransactionAuthorisationRequest(TransactionAuthorisationRequestTO transactionAuthorisationRequest, ConsentEntity consentEntity) {
        if (transactionAuthorisationRequest == null && consentEntity == null) {
            return null;
        }
        TransactionAuthorisationRequest transactionAuthorisationRequest1 = new TransactionAuthorisationRequest();
        if (transactionAuthorisationRequest != null) {
            transactionAuthorisationRequest1.setScaAuthenticationData(transactionAuthorisationRequest.getScaAuthenticationData());
        }
        if (consentEntity != null) {
            transactionAuthorisationRequest1.setConsentId(consentEntity.getId());
            transactionAuthorisationRequest1.setBankApiConsentData(consentEntity.getBankApiConsentData());
            transactionAuthorisationRequest1.setAuthorisationId(consentEntity.getAuthorisationId());
            transactionAuthorisationRequest1.setPsuAccountIban(consentEntity.getPsuAccountIban());
        }
        return transactionAuthorisationRequest1;
    }

    protected Credentials updatePsuAuthenticationRequestTOToCredentials(UpdatePsuAuthenticationRequestTO updatePsuAuthenticationRequestTO) {
        if (updatePsuAuthenticationRequestTO == null) {
            return null;
        }
        Credentials.CredentialsBuilder credentials = Credentials.builder();
        credentials.userId(updatePsuAuthenticationRequestTO.getPsuCorporateId());
        credentials.customerId(updatePsuAuthenticationRequestTO.getPsuId());
        credentials.pin(updatePsuAuthenticationRequestTO.getPassword());
        return credentials.build();
    }

    protected AuthenticationTypeTO authenticationTypeToAuthenticationTypeTO(AuthenticationType authenticationType) {
        AuthenticationTypeTO authenticationTypeTO;
        if (authenticationType == null) {
            return null;
        }
        switch (1.$SwitchMap$de$adorsys$multibanking$domain$AuthenticationType[authenticationType.ordinal()]) {
            case 1: {
                authenticationTypeTO = AuthenticationTypeTO.SMS_OTP;
                break;
            }
            case 2: {
                authenticationTypeTO = AuthenticationTypeTO.CHIP_OTP;
                break;
            }
            case 3: {
                authenticationTypeTO = AuthenticationTypeTO.PHOTO_OTP;
                break;
            }
            case 4: {
                authenticationTypeTO = AuthenticationTypeTO.PUSH_OTP;
                break;
            }
            case 5: {
                authenticationTypeTO = AuthenticationTypeTO.EMAIL;
                break;
            }
            case 6: {
                authenticationTypeTO = AuthenticationTypeTO.APP_OTP;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + authenticationType);
            }
        }
        return authenticationTypeTO;
    }

    protected TanTransportTypeTO tanTransportTypeToTanTransportTypeTO(TanTransportType tanTransportType) {
        if (tanTransportType == null) {
            return null;
        }
        TanTransportTypeTO tanTransportTypeTO = new TanTransportTypeTO();
        tanTransportTypeTO.setId(tanTransportType.getId());
        tanTransportTypeTO.setName(tanTransportType.getName());
        tanTransportTypeTO.setMedium(tanTransportType.getMedium());
        tanTransportTypeTO.setInputInfo(tanTransportType.getInputInfo());
        tanTransportTypeTO.setType(this.authenticationTypeToAuthenticationTypeTO(tanTransportType.getType()));
        return tanTransportTypeTO;
    }

    protected List<TanTransportTypeTO> tanTransportTypeListToTanTransportTypeTOList(List<TanTransportType> list) {
        if (list == null) {
            return null;
        }
        ArrayList<TanTransportTypeTO> list1 = new ArrayList<TanTransportTypeTO>(list.size());
        for (TanTransportType tanTransportType : list) {
            list1.add(this.tanTransportTypeToTanTransportTypeTO(tanTransportType));
        }
        return list1;
    }

    protected ScaStatusTO scaStatusToScaStatusTO(ScaStatus scaStatus) {
        ScaStatusTO scaStatusTO;
        if (scaStatus == null) {
            return null;
        }
        switch (1.$SwitchMap$de$adorsys$multibanking$domain$ScaStatus[scaStatus.ordinal()]) {
            case 1: {
                scaStatusTO = ScaStatusTO.RECEIVED;
                break;
            }
            case 2: {
                scaStatusTO = ScaStatusTO.STARTED;
                break;
            }
            case 3: {
                scaStatusTO = ScaStatusTO.PSUIDENTIFIED;
                break;
            }
            case 4: {
                scaStatusTO = ScaStatusTO.PSUAUTHENTICATED;
                break;
            }
            case 5: {
                scaStatusTO = ScaStatusTO.SCAMETHODSELECTED;
                break;
            }
            case 6: {
                scaStatusTO = ScaStatusTO.FINALISED;
                break;
            }
            case 7: {
                scaStatusTO = ScaStatusTO.FAILED;
                break;
            }
            case 8: {
                scaStatusTO = ScaStatusTO.EXEMPTED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + scaStatus);
            }
        }
        return scaStatusTO;
    }

    protected ChallengeDataTO challengeDataToChallengeDataTO(ChallengeData challengeData) {
        if (challengeData == null) {
            return null;
        }
        ChallengeDataTO challengeDataTO = new ChallengeDataTO();
        challengeDataTO.setImage(challengeData.getImage());
        List list = challengeData.getData();
        if (list != null) {
            challengeDataTO.setData(new ArrayList(list));
        }
        challengeDataTO.setImageLink(challengeData.getImageLink());
        challengeDataTO.setOtpMaxLength(challengeData.getOtpMaxLength());
        challengeDataTO.setOtpFormat(challengeData.getOtpFormat());
        challengeDataTO.setAdditionalInformation(challengeData.getAdditionalInformation());
        return challengeDataTO;
    }

    protected ScaApproachTO scaApproachToScaApproachTO(ScaApproach scaApproach) {
        ScaApproachTO scaApproachTO;
        if (scaApproach == null) {
            return null;
        }
        switch (1.$SwitchMap$de$adorsys$multibanking$domain$ScaApproach[scaApproach.ordinal()]) {
            case 1: {
                scaApproachTO = ScaApproachTO.EMBEDDED;
                break;
            }
            case 2: {
                scaApproachTO = ScaApproachTO.REDIRECT;
                break;
            }
            case 3: {
                scaApproachTO = ScaApproachTO.DECOUPLED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + scaApproach);
            }
        }
        return scaApproachTO;
    }
}

