/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.web;

import de.adorsys.multibanking.domain.BankAccessEntity;
import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.BankAccountEntity;
import de.adorsys.multibanking.domain.ScaStatus;
import de.adorsys.multibanking.exception.ResourceNotFoundException;
import de.adorsys.multibanking.exception.SyncInProgressException;
import de.adorsys.multibanking.exception.domain.Messages;
import de.adorsys.multibanking.pers.spi.repository.BankAccessRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.BankAccountRepositoryIf;
import de.adorsys.multibanking.service.BankAccountService;
import de.adorsys.multibanking.service.BookingService;
import de.adorsys.multibanking.web.BankAccessController;
import de.adorsys.multibanking.web.BankAccountAnalyticsController;
import de.adorsys.multibanking.web.BookingController;
import de.adorsys.multibanking.web.UserResource;
import de.adorsys.multibanking.web.mapper.BankAccountMapper;
import de.adorsys.multibanking.web.model.BankAccountTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.security.Principal;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Multibanking bankaccount"})
@UserResource
@RestController
@RequestMapping(path={"api/v1/bankaccesses/{accessId}/accounts"})
public class BankAccountController {
    private static final Logger log = LoggerFactory.getLogger(BankAccountController.class);
    private final BankAccountMapper bankAccountMapper;
    private final BankAccountService bankAccountService;
    private final BookingService bookingService;
    private final BankAccountRepositoryIf bankAccountRepository;
    private final BankAccessRepositoryIf bankAccessRepository;
    private final Principal principal;

    @ApiOperation(value="Read bank accounts", authorizations={@Authorization(value="multibanking_auth", scopes={@AuthorizationScope(scope="openid", description="")})})
    @ApiResponses(value={@ApiResponse(code=400, message="Consent authorisation required", response=Messages.class)})
    @GetMapping
    public Resources<Resource<BankAccountTO>> getBankAccounts(@PathVariable String accessId) {
        List bankAccounts = this.bankAccountService.getBankAccounts(this.principal.getName(), accessId);
        return new Resources((Iterable)this.mapToResources(bankAccounts, accessId), new Link[0]);
    }

    @ApiOperation(value="Read bank account", authorizations={@Authorization(value="multibanking_auth", scopes={@AuthorizationScope(scope="openid", description="")})})
    @GetMapping(value={"/{accountId}"})
    public Resource<BankAccountTO> getBankAccount(@PathVariable String accessId, @PathVariable(value="accountId") String accountId) {
        if (!this.bankAccessRepository.exists(accessId)) {
            throw new ResourceNotFoundException(BankAccessEntity.class, accessId);
        }
        BankAccountEntity bankAccountEntity = (BankAccountEntity)this.bankAccountRepository.findByUserIdAndId(this.principal.getName(), accountId).orElseThrow(() -> new ResourceNotFoundException(BankAccountEntity.class, accountId));
        return this.mapToResource(bankAccountEntity, accessId);
    }

    @ApiOperation(value="Trigger account sync", authorizations={@Authorization(value="multibanking_auth", scopes={@AuthorizationScope(scope="openid", description="")})})
    @ApiResponses(value={@ApiResponse(code=204, message="Sync started", response=void.class)})
    @PutMapping(value={"/{accountId}/sync"})
    public ResponseEntity syncBookings(@PathVariable String accessId, @PathVariable String accountId) {
        BankAccessEntity bankAccess = (BankAccessEntity)this.bankAccessRepository.findByUserIdAndId(this.principal.getName(), accessId).orElseThrow(() -> new ResourceNotFoundException(BankAccessEntity.class, accessId));
        BankAccountEntity bankAccount = (BankAccountEntity)this.bankAccountRepository.findByUserIdAndId(this.principal.getName(), accountId).orElseThrow(() -> new ResourceNotFoundException(BankAccountEntity.class, accountId));
        if (bankAccount.getSyncStatus() == BankAccount.SyncStatus.SYNC) {
            throw new SyncInProgressException(bankAccount.getId());
        }
        this.bookingService.syncBookings(ScaStatus.FINALISED, bankAccess, bankAccount, null);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    private List<Resource<BankAccountTO>> mapToResources(List<BankAccountEntity> accountEntities, String accessId) {
        return accountEntities.stream().map(accountEntity -> this.mapToResource(accountEntity, accessId)).collect(Collectors.toList());
    }

    private Resource<BankAccountTO> mapToResource(BankAccountEntity accountEntity, String accessId) {
        return new Resource((Object)this.bankAccountMapper.toBankAccountTO(accountEntity), new Link[]{ControllerLinkBuilder.linkTo((Object)((BankAccountController)ControllerLinkBuilder.methodOn(BankAccountController.class, (Object[])new Object[0])).getBankAccount(accessId, accountEntity.getId())).withSelfRel(), ControllerLinkBuilder.linkTo((Object)((BankAccessController)ControllerLinkBuilder.methodOn(BankAccessController.class, (Object[])new Object[0])).getBankAccess(accessId)).withRel("bankAccess"), ControllerLinkBuilder.linkTo((Object)((BankAccountAnalyticsController)ControllerLinkBuilder.methodOn(BankAccountAnalyticsController.class, (Object[])new Object[0])).getAccountAnalytics(accessId, accountEntity.getId())).withRel("analytics"), ControllerLinkBuilder.linkTo((Object)((BankAccountController)ControllerLinkBuilder.methodOn(BankAccountController.class, (Object[])new Object[0])).syncBookings(accessId, accountEntity.getId())).withRel("sync"), ControllerLinkBuilder.linkTo((Object)((BookingController)ControllerLinkBuilder.methodOn(BookingController.class, (Object[])new Object[0])).getBookings(accessId, accountEntity.getId(), null, null, null, null)).withRel("bookings")});
    }

    public BankAccountController(BankAccountMapper bankAccountMapper, BankAccountService bankAccountService, BookingService bookingService, BankAccountRepositoryIf bankAccountRepository, BankAccessRepositoryIf bankAccessRepository, Principal principal) {
        this.bankAccountMapper = bankAccountMapper;
        this.bankAccountService = bankAccountService;
        this.bookingService = bookingService;
        this.bankAccountRepository = bankAccountRepository;
        this.bankAccessRepository = bankAccessRepository;
        this.principal = principal;
    }
}

