/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.web;

import de.adorsys.multibanking.domain.AccountAnalyticsEntity;
import de.adorsys.multibanking.domain.BankAccessEntity;
import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.BankAccountEntity;
import de.adorsys.multibanking.exception.ResourceNotFoundException;
import de.adorsys.multibanking.exception.SyncInProgressException;
import de.adorsys.multibanking.pers.spi.repository.AnalyticsRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.BankAccessRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.BankAccountRepositoryIf;
import de.adorsys.multibanking.web.UserResource;
import de.adorsys.multibanking.web.mapper.AnalyticsMapper;
import de.adorsys.multibanking.web.model.AnalyticsTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.security.Principal;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Multibanking analytics"})
@UserResource
@RestController
@RequestMapping(path={"api/v1/bankaccesses/{accessId}/accounts/{accountId}/analytics"})
public class BankAccountAnalyticsController {
    private final AnalyticsMapper analyticsMapper;
    private final AnalyticsRepositoryIf analyticsRepository;
    private final BankAccessRepositoryIf bankAccessRepository;
    private final BankAccountRepositoryIf bankAccountRepository;
    private final Principal principal;

    @ApiOperation(value="Read account analytics", authorizations={@Authorization(value="multibanking_auth", scopes={@AuthorizationScope(scope="openid", description="")})})
    @GetMapping
    public Resource<AnalyticsTO> getAccountAnalytics(@PathVariable String accessId, @PathVariable String accountId) {
        if (!this.bankAccessRepository.exists(accessId)) {
            throw new ResourceNotFoundException(BankAccessEntity.class, accessId);
        }
        if (!this.bankAccountRepository.exists(accountId)) {
            throw new ResourceNotFoundException(BankAccountEntity.class, accountId);
        }
        if (this.bankAccountRepository.getSyncStatus(accountId) == BankAccount.SyncStatus.SYNC) {
            throw new SyncInProgressException(accountId);
        }
        AccountAnalyticsEntity accountAnalyticsEntity = (AccountAnalyticsEntity)this.analyticsRepository.findLastByUserIdAndAccountId(this.principal.getName(), accountId).orElseThrow(() -> new ResourceNotFoundException(AccountAnalyticsEntity.class, "user-id: " + this.principal.getName()));
        return new Resource((Object)this.analyticsMapper.toAnalyticsTO(accountAnalyticsEntity), new Link[0]);
    }

    public BankAccountAnalyticsController(AnalyticsMapper analyticsMapper, AnalyticsRepositoryIf analyticsRepository, BankAccessRepositoryIf bankAccessRepository, BankAccountRepositoryIf bankAccountRepository, Principal principal) {
        this.analyticsMapper = analyticsMapper;
        this.analyticsRepository = analyticsRepository;
        this.bankAccessRepository = bankAccessRepository;
        this.bankAccountRepository = bankAccountRepository;
        this.principal = principal;
    }
}

