/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service;

import de.adorsys.multibanking.config.FinTSProductConfig;
import de.adorsys.multibanking.domain.Bank;
import de.adorsys.multibanking.domain.BankAccess;
import de.adorsys.multibanking.domain.BankAccessEntity;
import de.adorsys.multibanking.domain.BankApiUser;
import de.adorsys.multibanking.domain.BankEntity;
import de.adorsys.multibanking.domain.Credentials;
import de.adorsys.multibanking.domain.StandingOrderEntity;
import de.adorsys.multibanking.domain.exception.MultibankingException;
import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.response.AuthorisationCodeResponse;
import de.adorsys.multibanking.domain.spi.OnlineBankingService;
import de.adorsys.multibanking.domain.transaction.AbstractScaTransaction;
import de.adorsys.multibanking.domain.transaction.StandingOrder;
import de.adorsys.multibanking.exception.PaymentException;
import de.adorsys.multibanking.exception.domain.MissingPinException;
import de.adorsys.multibanking.pers.spi.repository.StandingOrderRepositoryIf;
import de.adorsys.multibanking.service.BankService;
import de.adorsys.multibanking.service.OnlineBankingServiceProducer;
import de.adorsys.multibanking.service.UserService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class StandingOrderService {
    private static final Logger log = LoggerFactory.getLogger(StandingOrderService.class);
    private final BankService bankService;
    private final UserService userService;
    private final StandingOrderRepositoryIf standingOrderRepository;
    private final OnlineBankingServiceProducer bankingServiceProducer;
    private final FinTSProductConfig finTSProductConfig;

    Object createStandingOrder(BankAccessEntity bankAccess, Credentials credentials, StandingOrder standingOrder) {
        OnlineBankingService bankingService = this.bankingServiceProducer.getBankingService(bankAccess.getBankCode());
        BankApiUser bankApiUser = this.userService.checkApiRegistration(bankingService, this.userService.findUser(bankAccess.getUserId()));
        if (credentials.getPin() == null) {
            throw new MissingPinException();
        }
        BankEntity bankEntity = this.bankService.findBank(bankAccess.getBankCode());
        try {
            TransactionRequest request = new TransactionRequest((AbstractScaTransaction)standingOrder);
            request.setBankApiUser(bankApiUser);
            request.setBankAccess((BankAccess)bankAccess);
            request.setBank((Bank)bankEntity);
            request.setHbciProduct(this.finTSProductConfig.getProduct());
            AuthorisationCodeResponse tanSubmit = bankingService.initiatePayment(request);
            StandingOrderEntity target = new StandingOrderEntity();
            BeanUtils.copyProperties((Object)standingOrder, (Object)target);
            target.setCreatedDateTime(new Date());
            target.setUserId(bankAccess.getUserId());
            target.setTanSubmitExternal((Object)tanSubmit);
            this.standingOrderRepository.save(target);
            return tanSubmit;
        }
        catch (MultibankingException e) {
            throw new PaymentException(e.getMessage());
        }
    }

    void submitStandingOrder(StandingOrder standingOrder, Object tanSubmit, BankAccessEntity bankAccess, Credentials credentials, String tan) {
        OnlineBankingService bankingService = this.bankingServiceProducer.getBankingService(bankAccess.getBankCode());
        if (credentials == null) {
            throw new MissingPinException();
        }
    }

    public StandingOrderService(BankService bankService, UserService userService, StandingOrderRepositoryIf standingOrderRepository, OnlineBankingServiceProducer bankingServiceProducer, FinTSProductConfig finTSProductConfig) {
        this.bankService = bankService;
        this.userService = userService;
        this.standingOrderRepository = standingOrderRepository;
        this.bankingServiceProducer = bankingServiceProducer;
        this.finTSProductConfig = finTSProductConfig;
    }
}

