/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service;

import de.adorsys.multibanking.domain.spi.OnlineBankingService;
import de.adorsys.multibanking.pers.spi.repository.BankAccessRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.UserRepositoryIf;
import de.adorsys.multibanking.service.BankAccessService;
import de.adorsys.multibanking.service.OnlineBankingServiceProducer;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@Configuration
@EnableScheduling
public class DeleteExpiredUsersScheduled {
    private static final Logger log = LoggerFactory.getLogger(DeleteExpiredUsersScheduled.class);
    private final UserRepositoryIf userRepository;
    private final BankAccessRepositoryIf bankAccessRepository;
    private final BankAccessService bankAccessService;
    private final OnlineBankingServiceProducer onlineBankingServiceProducer;

    @Scheduled(fixedDelay=120000L)
    void deleteJob() {
        AtomicInteger count = new AtomicInteger(0);
        this.userRepository.findExpiredUser().forEach(userId -> {
            this.bankAccessRepository.findByUserId(userId).forEach(bankAccessEntity -> this.bankAccessService.deleteBankAccess(userId, bankAccessEntity.getId()));
            this.userRepository.findById(userId).ifPresent(userEntity -> {
                userEntity.getApiUser().forEach(bankApiUser -> {
                    OnlineBankingService bankingService = this.onlineBankingServiceProducer.getBankingService(bankApiUser.getBankApi());
                    if (bankingService.userRegistrationRequired()) {
                        bankingService.removeUser(bankApiUser);
                    }
                });
                this.userRepository.delete(userId);
            });
            count.incrementAndGet();
        });
        log.info("delete job done, [{}] users deleted", (Object)count);
    }

    @Bean
    public TaskScheduler poolScheduler() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setThreadNamePrefix("poolScheduler");
        return scheduler;
    }

    public DeleteExpiredUsersScheduled(UserRepositoryIf userRepository, BankAccessRepositoryIf bankAccessRepository, BankAccessService bankAccessService, OnlineBankingServiceProducer onlineBankingServiceProducer) {
        this.userRepository = userRepository;
        this.bankAccessRepository = bankAccessRepository;
        this.bankAccessService = bankAccessService;
        this.onlineBankingServiceProducer = onlineBankingServiceProducer;
    }
}

