/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service;

import de.adorsys.multibanking.domain.BankAccessEntity;
import de.adorsys.multibanking.domain.ConsentEntity;
import de.adorsys.multibanking.domain.exception.MultibankingError;
import de.adorsys.multibanking.domain.exception.MultibankingException;
import de.adorsys.multibanking.domain.response.AbstractResponse;
import de.adorsys.multibanking.domain.spi.OnlineBankingService;
import de.adorsys.multibanking.exception.InvalidConsentException;
import de.adorsys.multibanking.exception.InvalidPinException;
import de.adorsys.multibanking.exception.TransactionAuthorisationRequiredException;
import de.adorsys.multibanking.pers.spi.repository.BankAccessRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.ConsentRepositoryIf;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

abstract class AccountInformationService {
    @Autowired
    private BankAccessRepositoryIf bankAccessRepository;
    @Autowired
    private ConsentRepositoryIf consentRepository;

    AccountInformationService() {
    }

    RuntimeException handleMultibankingException(BankAccessEntity bankAccess, MultibankingException e) {
        if (e.getMultibankingError() == MultibankingError.INVALID_PIN) {
            return new InvalidPinException(bankAccess.getId());
        }
        if (e.getMultibankingError() == MultibankingError.INVALID_CONSENT) {
            bankAccess.setConsentId(null);
            this.bankAccessRepository.save(bankAccess);
            return new InvalidConsentException();
        }
        return e;
    }

    void checkScaRequired(AbstractResponse response, ConsentEntity consentEntity, OnlineBankingService onlineBankingService) {
        Optional.ofNullable(response.getAuthorisationCodeResponse()).ifPresent(authorisationCodeResponse -> {
            onlineBankingService.getStrongCustomerAuthorisation().afterExecute(consentEntity.getBankApiConsentData(), authorisationCodeResponse);
            this.consentRepository.save(consentEntity);
            throw new TransactionAuthorisationRequiredException(authorisationCodeResponse.getUpdateAuthResponse(), consentEntity.getId(), consentEntity.getAuthorisationId());
        });
    }
}

