/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.config;

import de.adorsys.multibanking.service.BankService;
import java.io.File;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
public class BankImportConfig {
    private static final Logger log = LoggerFactory.getLogger(BankImportConfig.class);
    private final BankService bankService;
    @Value(value="${bank.import.file:}")
    private String bankImportFile;

    @PostConstruct
    public void init() {
        if (StringUtils.isEmpty((Object)this.bankImportFile)) {
            return;
        }
        File importFile = new File(this.bankImportFile);
        if (!importFile.exists()) {
            log.error("File for bank import does not exist: {}", (Object)importFile.getAbsolutePath());
            return;
        }
        this.bankService.importBanks(importFile);
    }

    public BankImportConfig(BankService bankService) {
        this.bankService = bankService;
    }
}

