/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.web.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotBlank;
import org.springframework.hateoas.core.Relation;

@ApiModel(description="BankAccess account information", value="BankAccess")
@Relation(collectionRelation="bankAccessList")
public class BankAccessTO {
    @ApiModelProperty(value="Internal bank access id", readOnly=true, accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private String id;
    @ApiModelProperty(value="PSD2 consent id", readOnly=true, accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private String consentId;
    @NotBlank
    @ApiModelProperty(value="IBAN", required=true, example="DE51250400903312345678")
    private String iban;
    @ApiModelProperty(value="Bank name", example="Deutsche Bank", readOnly=true, accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private String bankName;
    @ApiModelProperty(value="Store bookings")
    private boolean storeBookings;
    @ApiModelProperty(value="Categorize bookings")
    private boolean categorizeBookings;
    @ApiModelProperty(value="Store analytics")
    private boolean storeAnalytics;
    @ApiModelProperty(value="Store anonymized bookings")
    private boolean storeAnonymizedBookings;
    @ApiModelProperty(value="Provide anonymized bookings for machine learning")
    private boolean provideDataForMachineLearning;

    public String getId() {
        return this.id;
    }

    public String getConsentId() {
        return this.consentId;
    }

    public String getIban() {
        return this.iban;
    }

    public String getBankName() {
        return this.bankName;
    }

    public boolean isStoreBookings() {
        return this.storeBookings;
    }

    public boolean isCategorizeBookings() {
        return this.categorizeBookings;
    }

    public boolean isStoreAnalytics() {
        return this.storeAnalytics;
    }

    public boolean isStoreAnonymizedBookings() {
        return this.storeAnonymizedBookings;
    }

    public boolean isProvideDataForMachineLearning() {
        return this.provideDataForMachineLearning;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setConsentId(String consentId) {
        this.consentId = consentId;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public void setStoreBookings(boolean storeBookings) {
        this.storeBookings = storeBookings;
    }

    public void setCategorizeBookings(boolean categorizeBookings) {
        this.categorizeBookings = categorizeBookings;
    }

    public void setStoreAnalytics(boolean storeAnalytics) {
        this.storeAnalytics = storeAnalytics;
    }

    public void setStoreAnonymizedBookings(boolean storeAnonymizedBookings) {
        this.storeAnonymizedBookings = storeAnonymizedBookings;
    }

    public void setProvideDataForMachineLearning(boolean provideDataForMachineLearning) {
        this.provideDataForMachineLearning = provideDataForMachineLearning;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BankAccessTO)) {
            return false;
        }
        BankAccessTO other = (BankAccessTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$consentId = this.getConsentId();
        String other$consentId = other.getConsentId();
        if (this$consentId == null ? other$consentId != null : !this$consentId.equals(other$consentId)) {
            return false;
        }
        String this$iban = this.getIban();
        String other$iban = other.getIban();
        if (this$iban == null ? other$iban != null : !this$iban.equals(other$iban)) {
            return false;
        }
        String this$bankName = this.getBankName();
        String other$bankName = other.getBankName();
        if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
            return false;
        }
        if (this.isStoreBookings() != other.isStoreBookings()) {
            return false;
        }
        if (this.isCategorizeBookings() != other.isCategorizeBookings()) {
            return false;
        }
        if (this.isStoreAnalytics() != other.isStoreAnalytics()) {
            return false;
        }
        if (this.isStoreAnonymizedBookings() != other.isStoreAnonymizedBookings()) {
            return false;
        }
        return this.isProvideDataForMachineLearning() == other.isProvideDataForMachineLearning();
    }

    protected boolean canEqual(Object other) {
        return other instanceof BankAccessTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $consentId = this.getConsentId();
        result = result * 59 + ($consentId == null ? 43 : $consentId.hashCode());
        String $iban = this.getIban();
        result = result * 59 + ($iban == null ? 43 : $iban.hashCode());
        String $bankName = this.getBankName();
        result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
        result = result * 59 + (this.isStoreBookings() ? 79 : 97);
        result = result * 59 + (this.isCategorizeBookings() ? 79 : 97);
        result = result * 59 + (this.isStoreAnalytics() ? 79 : 97);
        result = result * 59 + (this.isStoreAnonymizedBookings() ? 79 : 97);
        result = result * 59 + (this.isProvideDataForMachineLearning() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "BankAccessTO(id=" + this.getId() + ", consentId=" + this.getConsentId() + ", iban=" + this.getIban() + ", bankName=" + this.getBankName() + ", storeBookings=" + this.isStoreBookings() + ", categorizeBookings=" + this.isCategorizeBookings() + ", storeAnalytics=" + this.isStoreAnalytics() + ", storeAnonymizedBookings=" + this.isStoreAnonymizedBookings() + ", provideDataForMachineLearning=" + this.isProvideDataForMachineLearning() + ")";
    }
}

