/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.web.mapper;

import de.adorsys.multibanking.domain.AccountReference;
import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.Consent;
import de.adorsys.multibanking.domain.ConsentEntity;
import de.adorsys.multibanking.domain.response.CreateConsentResponse;
import de.adorsys.multibanking.web.mapper.ConsentMapper;
import de.adorsys.multibanking.web.model.AccountReferenceTO;
import de.adorsys.multibanking.web.model.ConsentTO;
import de.adorsys.multibanking.web.model.CreateConsentResponseTO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class MultibankingConsentMapperImpl
implements ConsentMapper {
    public ConsentTO toConsentTO(Consent consent) {
        if (consent == null) {
            return null;
        }
        ConsentTO consentTO = new ConsentTO();
        consentTO.setAccounts(this.accountReferenceListToAccountReferenceTOList(consent.getAccounts()));
        consentTO.setBalances(this.accountReferenceListToAccountReferenceTOList(consent.getBalances()));
        consentTO.setTransactions(this.accountReferenceListToAccountReferenceTOList(consent.getTransactions()));
        consentTO.setRecurringIndicator(consent.isRecurringIndicator());
        consentTO.setValidUntil(consent.getValidUntil());
        consentTO.setFrequencyPerDay(consent.getFrequencyPerDay());
        return consentTO;
    }

    public Consent toConsent(ConsentTO consent) {
        if (consent == null) {
            return null;
        }
        Consent consent1 = new Consent();
        consent1.setPsuAccountIban(consent.getPsuAccountIban());
        consent1.setAccounts(this.accountReferenceTOListToAccountReferenceList(consent.getAccounts()));
        consent1.setBalances(this.accountReferenceTOListToAccountReferenceList(consent.getBalances()));
        consent1.setTransactions(this.accountReferenceTOListToAccountReferenceList(consent.getTransactions()));
        consent1.setRecurringIndicator(consent.isRecurringIndicator());
        consent1.setValidUntil(consent.getValidUntil());
        consent1.setFrequencyPerDay(consent.getFrequencyPerDay());
        return consent1;
    }

    public CreateConsentResponseTO toCreateConsentResponseTO(CreateConsentResponse createConsentResponseconsent) {
        if (createConsentResponseconsent == null) {
            return null;
        }
        CreateConsentResponseTO createConsentResponseTO = new CreateConsentResponseTO();
        createConsentResponseTO.setConsentId(createConsentResponseconsent.getConsentId());
        createConsentResponseTO.setAuthorisationId(createConsentResponseconsent.getAuthorisationId());
        return createConsentResponseTO;
    }

    public ConsentEntity toConsentEntity(CreateConsentResponse createConsentResponse, String psuAccountIban, BankApi bankApi) {
        if (createConsentResponse == null && psuAccountIban == null && bankApi == null) {
            return null;
        }
        ConsentEntity consentEntity = new ConsentEntity();
        if (createConsentResponse != null) {
            consentEntity.setAuthorisationId(createConsentResponse.getAuthorisationId());
            consentEntity.setBankApiConsentData(createConsentResponse.getBankApiConsentData());
            consentEntity.setId(createConsentResponse.getConsentId());
        }
        if (psuAccountIban != null) {
            consentEntity.setPsuAccountIban(psuAccountIban);
        }
        if (bankApi != null) {
            consentEntity.setBankApi(bankApi);
        }
        return consentEntity;
    }

    protected AccountReferenceTO accountReferenceToAccountReferenceTO(AccountReference accountReference) {
        if (accountReference == null) {
            return null;
        }
        AccountReferenceTO accountReferenceTO = new AccountReferenceTO();
        accountReferenceTO.setIban(accountReference.getIban());
        accountReferenceTO.setCurrency(accountReference.getCurrency());
        return accountReferenceTO;
    }

    protected List<AccountReferenceTO> accountReferenceListToAccountReferenceTOList(List<AccountReference> list) {
        if (list == null) {
            return null;
        }
        ArrayList<AccountReferenceTO> list1 = new ArrayList<AccountReferenceTO>(list.size());
        for (AccountReference accountReference : list) {
            list1.add(this.accountReferenceToAccountReferenceTO(accountReference));
        }
        return list1;
    }

    protected AccountReference accountReferenceTOToAccountReference(AccountReferenceTO accountReferenceTO) {
        if (accountReferenceTO == null) {
            return null;
        }
        AccountReference accountReference = new AccountReference();
        accountReference.setIban(accountReferenceTO.getIban());
        accountReference.setCurrency(accountReferenceTO.getCurrency());
        return accountReference;
    }

    protected List<AccountReference> accountReferenceTOListToAccountReferenceList(List<AccountReferenceTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<AccountReference> list1 = new ArrayList<AccountReference>(list.size());
        for (AccountReferenceTO accountReferenceTO : list) {
            list1.add(this.accountReferenceTOToAccountReference(accountReferenceTO));
        }
        return list1;
    }
}

