/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.web;

import de.adorsys.multibanking.domain.Consent;
import de.adorsys.multibanking.domain.response.CreateConsentResponse;
import de.adorsys.multibanking.pers.spi.repository.BankAccessRepositoryIf;
import de.adorsys.multibanking.service.ConsentService;
import de.adorsys.multibanking.web.ConsentAuthorisationController;
import de.adorsys.multibanking.web.UserResource;
import de.adorsys.multibanking.web.mapper.BankApiMapper;
import de.adorsys.multibanking.web.mapper.ConsentMapper;
import de.adorsys.multibanking.web.model.BankApiTO;
import de.adorsys.multibanking.web.model.ConsentTO;
import de.adorsys.multibanking.web.model.CreateConsentResponseTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Multibanking consent"})
@UserResource
@RestController
@RequestMapping(path={"api/v1/consents"})
public class ConsentController {
    private static final Logger log = LoggerFactory.getLogger(ConsentController.class);
    private final ConsentService consentService;
    private final ConsentMapper consentMapper;
    private final BankApiMapper bankApiMapper;
    private final BankAccessRepositoryIf bankAccessRepository;
    private final Principal principal;

    @ApiOperation(value="Create new consent")
    @PostMapping
    public ResponseEntity<Resource<CreateConsentResponseTO>> createConsent(@RequestBody ConsentTO consent, @RequestParam(required=false) BankApiTO bankApi) {
        Consent consentInput = this.consentMapper.toConsent(consent);
        CreateConsentResponse createConsentResponse = this.consentService.createConsent(consentInput, consent.getTppRedirectUri(), this.bankApiMapper.toBankApi(bankApi));
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(ControllerLinkBuilder.linkTo((Object)((ConsentController)ControllerLinkBuilder.methodOn(ConsentController.class, (Object[])new Object[0])).getConsent(createConsentResponse.getConsentId())).toUri());
        return new ResponseEntity((Object)this.mapToResource(createConsentResponse), (MultiValueMap)headers, HttpStatus.CREATED);
    }

    @ApiOperation(value="Read user consents")
    @GetMapping
    public Resources<Resource<ConsentTO>> getConsents() {
        List consents = this.bankAccessRepository.findByUserId(this.principal.getName()).stream().map(bankAccessEntity -> this.consentService.getConsent(bankAccessEntity.getConsentId())).collect(Collectors.toList());
        return new Resources((Iterable)this.mapToResources(consents), new Link[0]);
    }

    @ApiOperation(value="Read consent")
    @GetMapping(value={"/{consentId}"})
    public Resource<ConsentTO> getConsent(@PathVariable(value="consentId") String consentId) {
        return this.mapToResource(this.consentService.getConsent(consentId));
    }

    @ApiOperation(value="Delete consent")
    @DeleteMapping(value={"/{consentId}"})
    public HttpEntity<Void> deleteConsent(@PathVariable String consentId) {
        this.consentService.revokeConsent(consentId);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    private List<Resource<ConsentTO>> mapToResources(List<Consent> consents) {
        return consents.stream().map(arg_0 -> this.mapToResource(arg_0)).collect(Collectors.toList());
    }

    private Resource<ConsentTO> mapToResource(Consent consent) {
        return new Resource((Object)this.consentMapper.toConsentTO(consent), new Link[]{ControllerLinkBuilder.linkTo((Object)((ConsentController)ControllerLinkBuilder.methodOn(ConsentController.class, (Object[])new Object[0])).getConsent(consent.getConsentId())).withSelfRel()});
    }

    private Resource<CreateConsentResponseTO> mapToResource(CreateConsentResponse createConsentResponse) {
        String consentId = createConsentResponse.getConsentId();
        String authorisationId = createConsentResponse.getAuthorisationId();
        ArrayList<Link> links = new ArrayList<Link>();
        links.add(ControllerLinkBuilder.linkTo((Object)((ConsentAuthorisationController)ControllerLinkBuilder.methodOn(ConsentAuthorisationController.class, (Object[])new Object[0])).getConsentAuthorisationStatus(consentId, authorisationId)).withRel("authorisationStatus"));
        Optional.ofNullable(createConsentResponse.getRedirectUrl()).ifPresent(redirectUrl -> links.add(new Link(redirectUrl, "redirectUrl")));
        return new Resource((Object)this.consentMapper.toCreateConsentResponseTO(createConsentResponse), links);
    }

    public ConsentController(ConsentService consentService, ConsentMapper consentMapper, BankApiMapper bankApiMapper, BankAccessRepositoryIf bankAccessRepository, Principal principal) {
        this.consentService = consentService;
        this.consentMapper = consentMapper;
        this.bankApiMapper = bankApiMapper;
        this.bankAccessRepository = bankAccessRepository;
        this.principal = principal;
    }
}

