/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.web;

import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.ScaApproach;
import de.adorsys.multibanking.domain.response.UpdateAuthResponse;
import de.adorsys.multibanking.service.ConsentService;
import de.adorsys.multibanking.web.ConsentAuthorisationController;
import de.adorsys.multibanking.web.UserResource;
import de.adorsys.multibanking.web.mapper.ConsentAuthorisationMapper;
import de.adorsys.multibanking.web.model.SelectPsuAuthenticationMethodRequestTO;
import de.adorsys.multibanking.web.model.TransactionAuthorisationRequestTO;
import de.adorsys.multibanking.web.model.UpdateAuthResponseTO;
import de.adorsys.multibanking.web.model.UpdatePsuAuthenticationRequestTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Multibanking consent authorisation"})
@UserResource
@RestController
@RequestMapping(path={"api/v1/consents/{consentId}/authorisations/{authorisationId}"})
public class ConsentAuthorisationController {
    private static final Logger log = LoggerFactory.getLogger(ConsentAuthorisationController.class);
    private final ConsentService consentService;
    private final ConsentAuthorisationMapper consentAuthorisationMapper;

    @ApiOperation(value="Update authorisation (authenticate user)")
    @PutMapping(value={"/updatePsuAuthentication"})
    public ResponseEntity<Resource<UpdateAuthResponseTO>> updateAuthentication(@PathVariable String consentId, @PathVariable String authorisationId, @RequestBody @Valid UpdatePsuAuthenticationRequestTO updatePsuAuthenticationRequestTO) {
        UpdateAuthResponse updateAuthResponse = this.consentService.updatePsuAuthentication(updatePsuAuthenticationRequestTO, consentId);
        return ResponseEntity.ok((Object)this.mapToResource(updateAuthResponse, consentId, authorisationId));
    }

    @ApiOperation(value="Update authorisation (select SCA method)")
    @PutMapping(value={"/selectPsuAuthenticationMethod"})
    public ResponseEntity<Resource<UpdateAuthResponseTO>> selectAuthenticationMethod(@PathVariable String consentId, @PathVariable String authorisationId, @RequestBody @Valid SelectPsuAuthenticationMethodRequestTO selectPsuAuthenticationMethodRequest) {
        UpdateAuthResponse updateAuthResponse = this.consentService.selectPsuAuthenticationMethod(selectPsuAuthenticationMethodRequest, consentId);
        return ResponseEntity.ok((Object)this.mapToResource(updateAuthResponse, consentId, authorisationId));
    }

    @ApiOperation(value="Update authorisation (authorize transaction)")
    @PutMapping(value={"/transactionAuthorisation"})
    public ResponseEntity<Resource<UpdateAuthResponseTO>> transactionAuthorisation(@PathVariable String consentId, @PathVariable String authorisationId, @RequestBody @Valid TransactionAuthorisationRequestTO transactionAuthorisationRequest) {
        UpdateAuthResponse updateAuthResponse = this.consentService.authorizeConsent(transactionAuthorisationRequest, consentId);
        return ResponseEntity.ok((Object)this.mapToResource(updateAuthResponse, consentId, authorisationId));
    }

    @ApiOperation(value="Get consent authorisation status")
    @GetMapping
    public ResponseEntity<Resource<UpdateAuthResponseTO>> getConsentAuthorisationStatus(@PathVariable String consentId, @PathVariable String authorisationId) {
        UpdateAuthResponse updateAuthResponse = this.consentService.getAuthorisationStatus(consentId, authorisationId);
        return ResponseEntity.ok((Object)this.mapToResource(updateAuthResponse, consentId, authorisationId));
    }

    private Resource<UpdateAuthResponseTO> mapToResource(UpdateAuthResponse response, String consentId, String authorisationId) {
        ArrayList<Link> links = new ArrayList<Link>();
        links.add(ControllerLinkBuilder.linkTo((Object)((ConsentAuthorisationController)ControllerLinkBuilder.methodOn(ConsentAuthorisationController.class, (Object[])new Object[0])).getConsentAuthorisationStatus(consentId, authorisationId)).withSelfRel());
        if (response.getScaApproach() != ScaApproach.REDIRECT) {
            switch (1.$SwitchMap$de$adorsys$multibanking$domain$ScaStatus[response.getScaStatus().ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    links.add(ControllerLinkBuilder.linkTo((Object)((ConsentAuthorisationController)ControllerLinkBuilder.methodOn(ConsentAuthorisationController.class, (Object[])new Object[0])).updateAuthentication(consentId, authorisationId, null)).withRel("updateAuthentication"));
                    break;
                }
                case 4: {
                    if (response.getBankApi() == BankApi.HBCI) break;
                    links.add(ControllerLinkBuilder.linkTo((Object)((ConsentAuthorisationController)ControllerLinkBuilder.methodOn(ConsentAuthorisationController.class, (Object[])new Object[0])).selectAuthenticationMethod(consentId, authorisationId, null)).withRel("selectAuthenticationMethod"));
                    break;
                }
                case 5: {
                    links.add(ControllerLinkBuilder.linkTo((Object)((ConsentAuthorisationController)ControllerLinkBuilder.methodOn(ConsentAuthorisationController.class, (Object[])new Object[0])).transactionAuthorisation(consentId, authorisationId, null)).withRel("transactionAuthorisation"));
                    break;
                }
            }
        }
        return new Resource((Object)this.consentAuthorisationMapper.toUpdateAuthResponseTO(response), links);
    }

    public ConsentAuthorisationController(ConsentService consentService, ConsentAuthorisationMapper consentAuthorisationMapper) {
        this.consentService = consentService;
        this.consentAuthorisationMapper = consentAuthorisationMapper;
    }
}

