/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.web;

import de.adorsys.multibanking.domain.BankAccessEntity;
import de.adorsys.multibanking.exception.ResourceNotFoundException;
import de.adorsys.multibanking.pers.spi.repository.BankAccessRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.UserRepositoryIf;
import de.adorsys.multibanking.service.BankAccessService;
import de.adorsys.multibanking.web.BankAccountController;
import de.adorsys.multibanking.web.UserResource;
import de.adorsys.multibanking.web.mapper.BankAccessMapper;
import de.adorsys.multibanking.web.model.BankAccessTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Multibanking bankaccess"})
@UserResource
@RestController
@RequestMapping(path={"api/v1/bankaccesses"})
public class BankAccessController {
    private static final Logger log = LoggerFactory.getLogger(BankAccessController.class);
    private final BankAccessMapper bankAccessMapper;
    private final BankAccessRepositoryIf bankAccessRepository;
    private final UserRepositoryIf userRepository;
    private final BankAccessService bankAccessService;
    private final Principal principal;

    @ApiOperation(value="Read bank accesses", authorizations={@Authorization(value="multibanking_auth", scopes={@AuthorizationScope(scope="openid", description="")})})
    @GetMapping
    public Resources<Resource<BankAccessTO>> getBankAccesses() {
        if (!this.userRepository.exists(this.principal.getName())) {
            return new Resources(Collections.emptyList(), new Link[0]);
        }
        List accessEntities = this.bankAccessRepository.findByUserId(this.principal.getName());
        return new Resources((Iterable)this.mapToResources(accessEntities), new Link[0]);
    }

    @ApiOperation(value="Create new bank accesses", authorizations={@Authorization(value="multibanking_auth", scopes={@AuthorizationScope(scope="openid", description="")})})
    @PostMapping
    public ResponseEntity<Resource<BankAccessTO>> createBankAccess(@RequestBody BankAccessTO bankAccess) {
        BankAccessEntity persistedBankAccess = this.bankAccessService.createBankAccess(this.bankAccessMapper.toBankAccessEntity(bankAccess, this.principal.getName(), false));
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(ControllerLinkBuilder.linkTo((Object)((BankAccessController)ControllerLinkBuilder.methodOn(BankAccessController.class, (Object[])new Object[0])).getBankAccess(persistedBankAccess.getId())).toUri());
        return new ResponseEntity((Object)this.mapToResource(persistedBankAccess), (MultiValueMap)headers, HttpStatus.CREATED);
    }

    @ApiOperation(value="Read bank access", authorizations={@Authorization(value="multibanking_auth", scopes={@AuthorizationScope(scope="openid", description="")})})
    @GetMapping(value={"/{accessId}"})
    public Resource<BankAccessTO> getBankAccess(@PathVariable String accessId) {
        BankAccessEntity bankAccessEntity = (BankAccessEntity)this.bankAccessRepository.findByUserIdAndId(this.principal.getName(), accessId).orElseThrow(() -> new ResourceNotFoundException(BankAccessEntity.class, accessId));
        return this.mapToResource(bankAccessEntity);
    }

    @ApiOperation(value="Update bank access", authorizations={@Authorization(value="multibanking_auth", scopes={@AuthorizationScope(scope="openid", description="")})})
    @PutMapping(value={"/{accessId}"})
    public HttpEntity<Void> updateBankAccess(@PathVariable String accessId, @RequestBody BankAccessTO bankAccess) {
        this.bankAccessService.updateBankAccess(accessId, this.bankAccessMapper.toBankAccessEntity(bankAccess, this.principal.getName(), false));
        log.info("Bank access [{}] updated.", (Object)accessId);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @ApiOperation(value="Delete bank accesses", authorizations={@Authorization(value="multibanking_auth", scopes={@AuthorizationScope(scope="openid", description="")})})
    @DeleteMapping(value={"/{accessId}"})
    public HttpEntity<Void> deleteBankAccess(@PathVariable String accessId) {
        if (!this.bankAccessService.deleteBankAccess(this.principal.getName(), accessId)) {
            throw new ResourceNotFoundException(BankAccessEntity.class, accessId);
        }
        log.info("Bank Access [{}] deleted.", (Object)accessId);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    private List<Resource<BankAccessTO>> mapToResources(List<BankAccessEntity> accessEntities) {
        return accessEntities.stream().map(arg_0 -> this.mapToResource(arg_0)).collect(Collectors.toList());
    }

    private Resource<BankAccessTO> mapToResource(BankAccessEntity accessEntity) {
        return new Resource((Object)this.bankAccessMapper.toBankAccessTO(accessEntity), new Link[]{ControllerLinkBuilder.linkTo((Object)((BankAccessController)ControllerLinkBuilder.methodOn(BankAccessController.class, (Object[])new Object[0])).getBankAccess(accessEntity.getId())).withSelfRel(), ControllerLinkBuilder.linkTo((Object)((BankAccountController)ControllerLinkBuilder.methodOn(BankAccountController.class, (Object[])new Object[0])).getBankAccounts(accessEntity.getId())).withRel("accounts")});
    }

    public BankAccessController(BankAccessMapper bankAccessMapper, BankAccessRepositoryIf bankAccessRepository, UserRepositoryIf userRepository, BankAccessService bankAccessService, Principal principal) {
        this.bankAccessMapper = bankAccessMapper;
        this.bankAccessRepository = bankAccessRepository;
        this.userRepository = userRepository;
        this.bankAccessService = bankAccessService;
        this.principal = principal;
    }
}

