/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service;

import com.nimbusds.jwt.JWTClaimsSet;
import de.adorsys.sts.keymanagement.service.DecryptionService;
import net.minidev.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class SecretClaimDecryptionService {
    private static final Logger log = LoggerFactory.getLogger(SecretClaimDecryptionService.class);
    @Value(value="${sts.audience_name:}")
    private String audience;
    @Value(value="${sts.secret_claim_property_key:}")
    private String secretClaimPropertyKey;
    @Autowired(required=false)
    private DecryptionService decryptionService;

    public String decryptSecretClaim() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            log.warn("not authenticated");
            return null;
        }
        if (authentication.getCredentials() instanceof JWTClaimsSet) {
            JWTClaimsSet credentials = (JWTClaimsSet)authentication.getCredentials();
            JSONObject encryptedSecretClaims = (JSONObject)credentials.getClaim(this.secretClaimPropertyKey);
            String encryptedSecretClaim = encryptedSecretClaims.getAsString(this.audience);
            if (encryptedSecretClaim == null) {
                log.warn("missing secret claim");
                return null;
            }
            return this.decryptionService.decrypt(encryptedSecretClaim);
        }
        return null;
    }
}

