/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service;

import de.adorsys.multibanking.config.FinTSProductConfig;
import de.adorsys.multibanking.domain.Bank;
import de.adorsys.multibanking.domain.BankAccess;
import de.adorsys.multibanking.domain.BankAccessEntity;
import de.adorsys.multibanking.domain.BankApiUser;
import de.adorsys.multibanking.domain.BankEntity;
import de.adorsys.multibanking.domain.BulkPaymentEntity;
import de.adorsys.multibanking.domain.Credentials;
import de.adorsys.multibanking.domain.RawSepaTransactionEntity;
import de.adorsys.multibanking.domain.SinglePaymentEntity;
import de.adorsys.multibanking.domain.exception.MultibankingException;
import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.response.AuthorisationCodeResponse;
import de.adorsys.multibanking.domain.spi.OnlineBankingService;
import de.adorsys.multibanking.domain.transaction.AbstractScaTransaction;
import de.adorsys.multibanking.domain.transaction.BulkPayment;
import de.adorsys.multibanking.domain.transaction.RawSepaPayment;
import de.adorsys.multibanking.domain.transaction.SinglePayment;
import de.adorsys.multibanking.exception.PaymentException;
import de.adorsys.multibanking.exception.domain.MissingPinException;
import de.adorsys.multibanking.pers.spi.repository.BulkPaymentRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.RawSepaTransactionRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.SinglePaymentRepositoryIf;
import de.adorsys.multibanking.service.BankService;
import de.adorsys.multibanking.service.OnlineBankingServiceProducer;
import de.adorsys.multibanking.service.UserService;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class PaymentService {
    private final OnlineBankingServiceProducer bankingServiceProducer;
    private final UserService userService;
    private final BankService bankService;
    private final RawSepaTransactionRepositoryIf rawSepaTransactionRepository;
    private final SinglePaymentRepositoryIf singlePaymentRepository;
    private final BulkPaymentRepositoryIf bulkPaymentRepository;
    private final FinTSProductConfig finTSProductConfig;

    RawSepaTransactionEntity createSepaRawPayment(BankAccessEntity bankAccess, Credentials credentials, RawSepaPayment payment) {
        OnlineBankingService bankingService = this.bankingServiceProducer.getBankingService(bankAccess.getBankCode());
        BankApiUser bankApiUser = this.userService.checkApiRegistration(bankingService, this.userService.findUser(bankAccess.getUserId()));
        if (credentials.getPin() == null) {
            throw new MissingPinException();
        }
        BankEntity bankEntity = this.bankService.findBank(bankAccess.getBankCode());
        try {
            TransactionRequest request = new TransactionRequest((AbstractScaTransaction)payment, bankApiUser, (BankAccess)bankAccess);
            request.setBank((Bank)bankEntity);
            request.setHbciProduct(this.finTSProductConfig.getProduct());
            AuthorisationCodeResponse tanSubmit = bankingService.initiatePayment(request);
            RawSepaTransactionEntity target = new RawSepaTransactionEntity();
            BeanUtils.copyProperties((Object)payment, (Object)target);
            target.setUserId(bankAccess.getUserId());
            target.setCreatedDateTime(new Date());
            target.setTanSubmitExternal((Object)tanSubmit);
            this.rawSepaTransactionRepository.save(target);
            return target;
        }
        catch (MultibankingException e) {
            throw new PaymentException(e.getMessage());
        }
    }

    public SinglePaymentEntity createSinglePayment(BankAccessEntity bankAccess, Credentials credentials, SinglePayment payment) {
        OnlineBankingService bankingService = this.bankingServiceProducer.getBankingService(bankAccess.getBankCode());
        BankApiUser bankApiUser = this.userService.checkApiRegistration(bankingService, this.userService.findUser(bankAccess.getUserId()));
        if (credentials.getPin() == null) {
            throw new MissingPinException();
        }
        BankEntity bankEntity = this.bankService.findBank(bankAccess.getBankCode());
        try {
            TransactionRequest request = new TransactionRequest((AbstractScaTransaction)payment, bankApiUser, (BankAccess)bankAccess);
            request.setBank((Bank)bankEntity);
            request.setHbciProduct(this.finTSProductConfig.getProduct());
            AuthorisationCodeResponse tanSubmit = bankingService.initiatePayment(request);
            SinglePaymentEntity target = new SinglePaymentEntity();
            BeanUtils.copyProperties((Object)payment, (Object)target);
            target.setUserId(bankAccess.getUserId());
            target.setCreatedDateTime(new Date());
            target.setTanSubmitExternal((Object)tanSubmit);
            this.singlePaymentRepository.save(target);
            return target;
        }
        catch (MultibankingException e) {
            throw new PaymentException(e.getMessage());
        }
    }

    BulkPaymentEntity createBulkPayment(BankAccessEntity bankAccess, Credentials credentials, BulkPayment payment) {
        OnlineBankingService bankingService = this.bankingServiceProducer.getBankingService(bankAccess.getBankCode());
        BankApiUser bankApiUser = this.userService.checkApiRegistration(bankingService, this.userService.findUser(bankAccess.getUserId()));
        if (credentials.getPin() == null) {
            throw new MissingPinException();
        }
        BankEntity bankEntity = this.bankService.findBank(bankAccess.getBankCode());
        try {
            TransactionRequest request = new TransactionRequest((AbstractScaTransaction)payment, bankApiUser, (BankAccess)bankAccess);
            request.setBank((Bank)bankEntity);
            request.setHbciProduct(this.finTSProductConfig.getProduct());
            AuthorisationCodeResponse tanSubmit = bankingService.initiatePayment(request);
            BulkPaymentEntity target = new BulkPaymentEntity();
            BeanUtils.copyProperties((Object)payment, (Object)target);
            target.setUserId(bankAccess.getUserId());
            target.setCreatedDateTime(new Date());
            target.setTanSubmitExternal((Object)tanSubmit);
            this.bulkPaymentRepository.save(target);
            return target;
        }
        catch (MultibankingException e) {
            throw new PaymentException(e.getMessage());
        }
    }

    void submitRawSepaTransaction(RawSepaTransactionEntity transactionEntity, BankAccessEntity bankAccess, Credentials credentials, String tan) {
        OnlineBankingService bankingService = this.bankingServiceProducer.getBankingService(bankAccess.getBankCode());
        if (credentials == null) {
            throw new MissingPinException();
        }
        this.rawSepaTransactionRepository.delete(transactionEntity.getId());
    }

    public void submitSinglePayment(SinglePaymentEntity paymentEntity, BankAccessEntity bankAccess, Credentials credentials, String tan) {
        OnlineBankingService bankingService = this.bankingServiceProducer.getBankingService(bankAccess.getBankCode());
        if (credentials == null) {
            throw new MissingPinException();
        }
        this.singlePaymentRepository.delete(paymentEntity.getId());
    }

    void submitBulkPayment(BulkPaymentEntity paymentEntity, BankAccessEntity bankAccess, Credentials credentials, String tan) {
        OnlineBankingService bankingService = this.bankingServiceProducer.getBankingService(bankAccess.getBankCode());
        if (credentials == null) {
            throw new MissingPinException();
        }
        this.bulkPaymentRepository.delete(paymentEntity.getId());
    }

    public PaymentService(OnlineBankingServiceProducer bankingServiceProducer, UserService userService, BankService bankService, RawSepaTransactionRepositoryIf rawSepaTransactionRepository, SinglePaymentRepositoryIf singlePaymentRepository, BulkPaymentRepositoryIf bulkPaymentRepository, FinTSProductConfig finTSProductConfig) {
        this.bankingServiceProducer = bankingServiceProducer;
        this.userService = userService;
        this.bankService = bankService;
        this.rawSepaTransactionRepository = rawSepaTransactionRepository;
        this.singlePaymentRepository = singlePaymentRepository;
        this.bulkPaymentRepository = bulkPaymentRepository;
        this.finTSProductConfig = finTSProductConfig;
    }
}

