/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service;

import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.BankEntity;
import de.adorsys.multibanking.domain.Consent;
import de.adorsys.multibanking.domain.ConsentEntity;
import de.adorsys.multibanking.domain.ScaStatus;
import de.adorsys.multibanking.domain.exception.MultibankingException;
import de.adorsys.multibanking.domain.request.SelectPsuAuthenticationMethodRequest;
import de.adorsys.multibanking.domain.request.TransactionAuthorisationRequest;
import de.adorsys.multibanking.domain.request.UpdatePsuAuthenticationRequest;
import de.adorsys.multibanking.domain.response.CreateConsentResponse;
import de.adorsys.multibanking.domain.response.UpdateAuthResponse;
import de.adorsys.multibanking.domain.spi.OnlineBankingService;
import de.adorsys.multibanking.exception.MissingConsentAuthorisationSelectionException;
import de.adorsys.multibanking.exception.MissingConsentException;
import de.adorsys.multibanking.exception.ResourceNotFoundException;
import de.adorsys.multibanking.exception.TransactionAuthorisationRequiredException;
import de.adorsys.multibanking.pers.spi.repository.ConsentRepositoryIf;
import de.adorsys.multibanking.service.BankService;
import de.adorsys.multibanking.service.ConsentService;
import de.adorsys.multibanking.service.OnlineBankingServiceProducer;
import de.adorsys.multibanking.web.mapper.ConsentAuthorisationMapper;
import de.adorsys.multibanking.web.mapper.ConsentMapper;
import de.adorsys.multibanking.web.model.ConsentTO;
import de.adorsys.multibanking.web.model.SelectPsuAuthenticationMethodRequestTO;
import de.adorsys.multibanking.web.model.TransactionAuthorisationRequestTO;
import de.adorsys.multibanking.web.model.UpdatePsuAuthenticationRequestTO;
import java.util.Optional;
import org.iban4j.Iban;
import org.springframework.stereotype.Service;

@Service
public class ConsentService {
    private final ConsentRepositoryIf consentRepository;
    private final OnlineBankingServiceProducer bankingServiceProducer;
    private final ConsentAuthorisationMapper consentAuthorisationMapper;
    private final ConsentMapper consentMapper;
    private final BankService bankService;

    public CreateConsentResponse createConsent(Consent consent, String tppRedirectUri, BankApi bankApi) {
        OnlineBankingService onlineBankingService = this.getOnlineBankingService(bankApi, consent.getPsuAccountIban());
        BankEntity bank = this.bankService.findBank(Iban.valueOf((String)consent.getPsuAccountIban()).getBankCode());
        CreateConsentResponse createConsentResponse = onlineBankingService.getStrongCustomerAuthorisation().createConsent(consent, bank.isRedirectPreferred(), tppRedirectUri);
        ConsentEntity consentEntity = this.consentMapper.toConsentEntity(createConsentResponse, consent.getPsuAccountIban(), onlineBankingService.bankApi());
        this.consentRepository.save(consentEntity);
        return createConsentResponse;
    }

    public UpdateAuthResponse updatePsuAuthentication(UpdatePsuAuthenticationRequestTO updatePsuAuthenticationRequestTO, String consentId) {
        ConsentEntity internalConsent = (ConsentEntity)this.consentRepository.findById(consentId).orElseThrow(() -> new ResourceNotFoundException(ConsentEntity.class, consentId));
        OnlineBankingService onlineBankingService = this.bankingServiceProducer.getBankingService(internalConsent.getBankApi());
        BankEntity bank = this.bankService.findBank(Iban.valueOf((String)internalConsent.getPsuAccountIban()).getBankCode());
        UpdatePsuAuthenticationRequest updatePsuAuthenticationRequest = this.consentAuthorisationMapper.toUpdatePsuAuthenticationRequest(updatePsuAuthenticationRequestTO, internalConsent, bank);
        UpdateAuthResponse response = onlineBankingService.getStrongCustomerAuthorisation().updatePsuAuthentication(updatePsuAuthenticationRequest);
        internalConsent.setBankApiConsentData(updatePsuAuthenticationRequest.getBankApiConsentData());
        this.consentRepository.save(internalConsent);
        return response;
    }

    public UpdateAuthResponse selectPsuAuthenticationMethod(SelectPsuAuthenticationMethodRequestTO selectPsuAuthenticationMethodRequestTO, String consentId) {
        ConsentEntity internalConsent = (ConsentEntity)this.consentRepository.findById(consentId).orElseThrow(() -> new ResourceNotFoundException(ConsentEntity.class, consentId));
        OnlineBankingService onlineBankingService = this.bankingServiceProducer.getBankingService(internalConsent.getBankApi());
        SelectPsuAuthenticationMethodRequest selectPsuAuthenticationMethodRequest = this.consentAuthorisationMapper.toSelectPsuAuthenticationMethodRequest(selectPsuAuthenticationMethodRequestTO, internalConsent);
        UpdateAuthResponse response = onlineBankingService.getStrongCustomerAuthorisation().selectPsuAuthenticationMethod(selectPsuAuthenticationMethodRequest);
        internalConsent.setBankApiConsentData(selectPsuAuthenticationMethodRequest.getBankApiConsentData());
        this.consentRepository.save(internalConsent);
        return response;
    }

    public UpdateAuthResponse authorizeConsent(TransactionAuthorisationRequestTO transactionAuthorisationRequestTO, String consentId) {
        ConsentEntity internalConsent = (ConsentEntity)this.consentRepository.findById(consentId).orElseThrow(() -> new ResourceNotFoundException(ConsentEntity.class, consentId));
        OnlineBankingService onlineBankingService = this.bankingServiceProducer.getBankingService(internalConsent.getBankApi());
        TransactionAuthorisationRequest transactionAuthorisationRequest = this.consentAuthorisationMapper.toTransactionAuthorisationRequest(transactionAuthorisationRequestTO, internalConsent);
        UpdateAuthResponse response = onlineBankingService.getStrongCustomerAuthorisation().authorizeConsent(transactionAuthorisationRequest);
        internalConsent.setBankApiConsentData(transactionAuthorisationRequest.getBankApiConsentData());
        this.consentRepository.save(internalConsent);
        return response;
    }

    public void revokeConsent(String consentId) {
        ConsentEntity internalConsent = (ConsentEntity)this.consentRepository.findById(consentId).orElseThrow(() -> new ResourceNotFoundException(ConsentEntity.class, consentId));
        OnlineBankingService onlineBankingService = this.bankingServiceProducer.getBankingService(internalConsent.getBankApi());
        onlineBankingService.getStrongCustomerAuthorisation().revokeConsent(consentId);
        throw new ResourceNotFoundException(ConsentTO.class, consentId);
    }

    public Consent getConsent(String consentId) {
        ConsentEntity internalConsent = (ConsentEntity)this.consentRepository.findById(consentId).orElseThrow(() -> new ResourceNotFoundException(ConsentEntity.class, consentId));
        OnlineBankingService onlineBankingService = this.bankingServiceProducer.getBankingService(internalConsent.getBankApi());
        return onlineBankingService.getStrongCustomerAuthorisation().getConsent(consentId);
    }

    public UpdateAuthResponse getAuthorisationStatus(String consentId, String authorisationId) {
        ConsentEntity internalConsent = (ConsentEntity)this.consentRepository.findById(consentId).orElseThrow(() -> new ResourceNotFoundException(ConsentEntity.class, consentId));
        OnlineBankingService onlineBankingService = this.bankingServiceProducer.getBankingService(internalConsent.getBankApi());
        return onlineBankingService.getStrongCustomerAuthorisation().getAuthorisationStatus(consentId, authorisationId, internalConsent.getBankApiConsentData());
    }

    private OnlineBankingService getOnlineBankingService(BankApi bankApi, String iban) {
        return bankApi != null ? this.bankingServiceProducer.getBankingService(bankApi) : this.bankingServiceProducer.getBankingService(Iban.valueOf((String)iban).getBankCode());
    }

    Optional<ConsentEntity> validateAndGetConsent(OnlineBankingService onlineBankingService, String consentId, ScaStatus expectedConsentStatus) {
        if (onlineBankingService.getStrongCustomerAuthorisation() == null) {
            return Optional.empty();
        }
        ConsentEntity internalConsent = (ConsentEntity)this.consentRepository.findById(consentId).orElseThrow(() -> new ResourceNotFoundException(ConsentEntity.class, consentId));
        try {
            onlineBankingService.getStrongCustomerAuthorisation().validateConsent(internalConsent.getId(), internalConsent.getAuthorisationId(), expectedConsentStatus, internalConsent.getBankApiConsentData());
        }
        catch (MultibankingException e) {
            switch (1.$SwitchMap$de$adorsys$multibanking$domain$exception$MultibankingError[e.getMultibankingError().ordinal()]) {
                case 1: {
                    throw new MissingConsentException();
                }
                case 2: {
                    throw new MissingConsentAuthorisationSelectionException();
                }
                case 3: {
                    if (expectedConsentStatus == ScaStatus.FINALISED) {
                        throw new TransactionAuthorisationRequiredException(null, internalConsent.getId(), internalConsent.getAuthorisationId());
                    }
                    if (expectedConsentStatus == ScaStatus.SCAMETHODSELECTED) {
                        throw new MissingConsentAuthorisationSelectionException();
                    }
                    throw e;
                }
            }
            throw e;
        }
        return Optional.of(internalConsent);
    }

    public ConsentService(ConsentRepositoryIf consentRepository, OnlineBankingServiceProducer bankingServiceProducer, ConsentAuthorisationMapper consentAuthorisationMapper, ConsentMapper consentMapper, BankService bankService) {
        this.consentRepository = consentRepository;
        this.bankingServiceProducer = bankingServiceProducer;
        this.consentAuthorisationMapper = consentAuthorisationMapper;
        this.consentMapper = consentMapper;
        this.bankService = bankService;
    }
}

