/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service;

import de.adorsys.multibanking.domain.BankAccessEntity;
import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.BankAccountEntity;
import de.adorsys.multibanking.domain.BankApiUser;
import de.adorsys.multibanking.domain.UserEntity;
import de.adorsys.multibanking.domain.spi.OnlineBankingService;
import de.adorsys.multibanking.exception.InvalidBankAccessException;
import de.adorsys.multibanking.exception.ResourceNotFoundException;
import de.adorsys.multibanking.pers.spi.repository.AnalyticsRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.BankAccessRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.BankAccountRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.BookingRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.ConsentRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.ContractRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.StandingOrderRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.UserRepositoryIf;
import de.adorsys.multibanking.service.BankAccountService;
import de.adorsys.multibanking.service.OnlineBankingServiceProducer;
import de.adorsys.multibanking.service.UserService;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.iban4j.Iban;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BankAccessService {
    private static final Logger log = LoggerFactory.getLogger(BankAccessService.class);
    private final AnalyticsRepositoryIf analyticsRepository;
    private final ContractRepositoryIf contractRepository;
    private final StandingOrderRepositoryIf standingOrderRepository;
    private final UserRepositoryIf userRepository;
    private final UserService userService;
    private final BankAccountRepositoryIf bankAccountRepository;
    private final BankAccessRepositoryIf bankAccessRepository;
    private final BookingRepositoryIf bookingRepository;
    private final BankAccountService bankAccountService;
    private final ConsentRepositoryIf consentRepository;
    private final OnlineBankingServiceProducer bankingServiceProducer;

    public BankAccessEntity createBankAccess(BankAccessEntity bankAccess) {
        List bankAccounts;
        this.userService.checkUserExists(bankAccess.getUserId());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{bankAccess.getIban()})) {
            bankAccess.setBankCode(Iban.valueOf((String)bankAccess.getIban()).getBankCode());
        }
        if ((bankAccounts = this.bankAccountService.loadBankAccountsOnline(bankAccess, null)).isEmpty()) {
            throw new InvalidBankAccessException(bankAccess.getBankCode());
        }
        this.bankAccessRepository.save(bankAccess);
        bankAccounts.forEach(account -> account.setBankAccessId(bankAccess.getId()));
        this.bankAccountRepository.save(bankAccounts);
        log.info("[{}] accounts for connection [{}] created.", (Object)bankAccounts.size(), (Object)bankAccess.getId());
        return bankAccess;
    }

    public void updateBankAccess(String accessId, BankAccessEntity bankAccessEntity) {
        BankAccessEntity bankAccessEntityDb = (BankAccessEntity)this.bankAccessRepository.findByUserIdAndId(bankAccessEntity.getUserId(), accessId).orElseThrow(() -> new ResourceNotFoundException(BankAccessEntity.class, accessId));
        bankAccessEntityDb.setStoreBookings(bankAccessEntity.isStoreBookings());
        bankAccessEntityDb.setCategorizeBookings(bankAccessEntity.isCategorizeBookings());
        bankAccessEntityDb.setStoreAnalytics(bankAccessEntity.isStoreAnalytics());
        bankAccessEntityDb.setStoreAnonymizedBookings(bankAccessEntity.isStoreAnonymizedBookings());
        if (!bankAccessEntityDb.isStoreBookings() || !bankAccessEntityDb.isStoreAnalytics()) {
            this.bankAccountRepository.findByUserIdAndBankAccessId(bankAccessEntityDb.getUserId(), bankAccessEntityDb.getId()).forEach(bankAccountEntity -> {
                if (!bankAccessEntityDb.isStoreBookings()) {
                    this.bookingRepository.deleteByAccountId(bankAccountEntity.getId());
                }
                if (!bankAccessEntityDb.isStoreAnalytics()) {
                    this.analyticsRepository.deleteByAccountId(bankAccountEntity.getId());
                }
            });
        }
        this.bankAccessRepository.save(bankAccessEntityDb);
    }

    @Transactional
    public boolean deleteBankAccess(String userId, String accessId) {
        return this.bankAccessRepository.findByUserIdAndId(userId, accessId).map(bankAccessEntity -> {
            this.bankAccessRepository.deleteByUserIdAndBankAccessId(userId, accessId);
            this.deleteConsent(bankAccessEntity);
            List bankAccounts = this.bankAccountRepository.deleteByBankAccess(accessId);
            bankAccounts.forEach(bankAccountEntity -> {
                this.bookingRepository.deleteByAccountId(bankAccountEntity.getId());
                this.analyticsRepository.deleteByAccountId(bankAccountEntity.getId());
                this.contractRepository.deleteByAccountId(bankAccountEntity.getId());
                this.standingOrderRepository.deleteByAccountId(bankAccountEntity.getId());
                this.deleteExternalBankAccount(userId, bankAccountEntity);
            });
            return true;
        }).orElse(false);
    }

    private void deleteExternalBankAccount(String userId, BankAccountEntity bankAccountEntity) {
        bankAccountEntity.getExternalIdMap().keySet().forEach(bankApi -> {
            OnlineBankingService bankingService = this.bankingServiceProducer.getBankingService(bankApi);
            if (bankingService.userRegistrationRequired()) {
                UserEntity userEntity = (UserEntity)this.userRepository.findById(userId).orElseThrow(() -> new ResourceNotFoundException(UserEntity.class, userId));
                BankApiUser bankApiUser = userEntity.getApiUser().stream().filter(apiUser -> apiUser.getBankApi() == bankApi).findFirst().orElseThrow(() -> new ResourceNotFoundException(BankApiUser.class, bankApi.toString()));
                bankingService.removeBankAccount((BankAccount)bankAccountEntity, bankApiUser);
            }
        });
    }

    private void deleteConsent(BankAccessEntity bankAccessEntity) {
        Optional.ofNullable(bankAccessEntity.getConsentId()).map(arg_0 -> ((ConsentRepositoryIf)this.consentRepository).findById(arg_0)).map(Optional::get).ifPresent(internalConsent -> {
            OnlineBankingService bankingService = this.bankingServiceProducer.getBankingService(internalConsent.getBankApi());
            bankingService.getStrongCustomerAuthorisation().revokeConsent(internalConsent.getId());
            this.consentRepository.delete(internalConsent);
        });
    }

    public BankAccessService(AnalyticsRepositoryIf analyticsRepository, ContractRepositoryIf contractRepository, StandingOrderRepositoryIf standingOrderRepository, UserRepositoryIf userRepository, UserService userService, BankAccountRepositoryIf bankAccountRepository, BankAccessRepositoryIf bankAccessRepository, BookingRepositoryIf bookingRepository, BankAccountService bankAccountService, ConsentRepositoryIf consentRepository, OnlineBankingServiceProducer bankingServiceProducer) {
        this.analyticsRepository = analyticsRepository;
        this.contractRepository = contractRepository;
        this.standingOrderRepository = standingOrderRepository;
        this.userRepository = userRepository;
        this.userService = userService;
        this.bankAccountRepository = bankAccountRepository;
        this.bankAccessRepository = bankAccessRepository;
        this.bookingRepository = bookingRepository;
        this.bankAccountService = bankAccountService;
        this.consentRepository = consentRepository;
        this.bankingServiceProducer = bankingServiceProducer;
    }
}

