/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import de.adorsys.multibanking.config.AuthorizationClientRequestFactory;
import de.adorsys.multibanking.config.SmartanalyticsRemoteConfig;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.hateoas.hal.Jackson2HalModule;
import org.springframework.http.MediaType;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriTemplateHandler;

@Configuration
@Profile(value={"smartanalytics-remote"})
public class SmartanalyticsRemoteConfig {
    private static final Logger log = LoggerFactory.getLogger(SmartanalyticsRemoteConfig.class);
    @Value(value="${SMARTANALYTICS_URL:http://localhost:8082}")
    private String smartanalyticsUrl;

    @Bean
    @Qualifier(value="smartanalytics")
    public RestTemplate restTemplate(AuthorizationClientRequestFactory authorizationClientRequestFactory) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.registerModule((Module)new Jackson2HalModule());
        mapper.registerModule((Module)new JavaTimeModule());
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
        converter.setSupportedMediaTypes(MediaType.parseMediaTypes((String)"application/hal+json, application/json"));
        converter.setObjectMapper(mapper);
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)new BufferingClientHttpRequestFactory((ClientHttpRequestFactory)authorizationClientRequestFactory));
        restTemplate.setUriTemplateHandler((UriTemplateHandler)new DefaultUriBuilderFactory(this.smartanalyticsUrl));
        restTemplate.setErrorHandler((ResponseErrorHandler)new ErrorHandler(this, null));
        restTemplate.setMessageConverters(Collections.singletonList(converter));
        restTemplate.getInterceptors().add(new LoggingInterceptor(this, "SMARTANALYTICS"));
        return restTemplate;
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }
}

