package de.adorsys.multibanking.web.mapper;

import de.adorsys.multibanking.bg.domain.Consent;
import de.adorsys.multibanking.bg.domain.ConsentStatus;
import de.adorsys.multibanking.domain.AccountReference;
import de.adorsys.multibanking.web.model.AccountReferenceTO;
import de.adorsys.multibanking.web.model.ConsentTO;
import de.adorsys.multibanking.web.model.ScaStatusTO;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2019-08-08T14:32:38+0000",
    comments = "version: 1.3.0.Final, compiler: javac, environment: Java 1.8.0_151 (Oracle Corporation)"
)
@Component
public class MultibankingConsentMapperImpl implements ConsentMapper {

    @Override
    public ConsentTO toConsentTO(Consent consent) {
        if ( consent == null ) {
            return null;
        }

        ConsentTO consentTO = new ConsentTO();

        consentTO.setConsentId( consent.getConsentId() );
        consentTO.setConsentAuthorisationId( consent.getConsentAuthorisationId() );
        consentTO.setRedirectUrl( consent.getRedirectUrl() );
        consentTO.setAccounts( accountReferenceListToAccountReferenceTOList( consent.getAccounts() ) );
        consentTO.setBalances( accountReferenceListToAccountReferenceTOList( consent.getBalances() ) );
        consentTO.setTransactions( accountReferenceListToAccountReferenceTOList( consent.getTransactions() ) );
        consentTO.setRecurringIndicator( consent.isRecurringIndicator() );
        consentTO.setValidUntil( consent.getValidUntil() );
        consentTO.setFrequencyPerDay( consent.getFrequencyPerDay() );
        consentTO.setScaStatus( consentStatusToScaStatusTO( consent.getScaStatus() ) );

        return consentTO;
    }

    @Override
    public Consent toConsent(ConsentTO consent) {
        if ( consent == null ) {
            return null;
        }

        Consent consent1 = new Consent();

        consent1.setConsentId( consent.getConsentId() );
        consent1.setConsentAuthorisationId( consent.getConsentAuthorisationId() );
        consent1.setRedirectUrl( consent.getRedirectUrl() );
        consent1.setScaStatus( scaStatusTOToConsentStatus( consent.getScaStatus() ) );
        consent1.setAccounts( accountReferenceTOListToAccountReferenceList( consent.getAccounts() ) );
        consent1.setBalances( accountReferenceTOListToAccountReferenceList( consent.getBalances() ) );
        consent1.setTransactions( accountReferenceTOListToAccountReferenceList( consent.getTransactions() ) );
        consent1.setRecurringIndicator( consent.isRecurringIndicator() );
        consent1.setValidUntil( consent.getValidUntil() );
        consent1.setFrequencyPerDay( consent.getFrequencyPerDay() );

        return consent1;
    }

    protected AccountReferenceTO accountReferenceToAccountReferenceTO(AccountReference accountReference) {
        if ( accountReference == null ) {
            return null;
        }

        AccountReferenceTO accountReferenceTO = new AccountReferenceTO();

        accountReferenceTO.setIban( accountReference.getIban() );

        return accountReferenceTO;
    }

    protected List<AccountReferenceTO> accountReferenceListToAccountReferenceTOList(List<AccountReference> list) {
        if ( list == null ) {
            return null;
        }

        List<AccountReferenceTO> list1 = new ArrayList<AccountReferenceTO>( list.size() );
        for ( AccountReference accountReference : list ) {
            list1.add( accountReferenceToAccountReferenceTO( accountReference ) );
        }

        return list1;
    }

    protected ScaStatusTO consentStatusToScaStatusTO(ConsentStatus consentStatus) {
        if ( consentStatus == null ) {
            return null;
        }

        ScaStatusTO scaStatusTO;

        switch ( consentStatus ) {
            case RECEIVED: scaStatusTO = ScaStatusTO.RECEIVED;
            break;
            case REJECTED: scaStatusTO = ScaStatusTO.REJECTED;
            break;
            case VALID: scaStatusTO = ScaStatusTO.VALID;
            break;
            case REVOKED_BY_PSU: scaStatusTO = ScaStatusTO.REVOKED_BY_PSU;
            break;
            case EXPIRED: scaStatusTO = ScaStatusTO.EXPIRED;
            break;
            case TERMINATED_BY_TPP: scaStatusTO = ScaStatusTO.TERMINATED_BY_TPP;
            break;
            case TERMINATED_BY_ASPSP: scaStatusTO = ScaStatusTO.TERMINATED_BY_ASPSP;
            break;
            case PARTIALLY_AUTHORISED: scaStatusTO = ScaStatusTO.PARTIALLY_AUTHORISED;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + consentStatus );
        }

        return scaStatusTO;
    }

    protected ConsentStatus scaStatusTOToConsentStatus(ScaStatusTO scaStatusTO) {
        if ( scaStatusTO == null ) {
            return null;
        }

        ConsentStatus consentStatus;

        switch ( scaStatusTO ) {
            case RECEIVED: consentStatus = ConsentStatus.RECEIVED;
            break;
            case REJECTED: consentStatus = ConsentStatus.REJECTED;
            break;
            case VALID: consentStatus = ConsentStatus.VALID;
            break;
            case REVOKED_BY_PSU: consentStatus = ConsentStatus.REVOKED_BY_PSU;
            break;
            case EXPIRED: consentStatus = ConsentStatus.EXPIRED;
            break;
            case TERMINATED_BY_TPP: consentStatus = ConsentStatus.TERMINATED_BY_TPP;
            break;
            case TERMINATED_BY_ASPSP: consentStatus = ConsentStatus.TERMINATED_BY_ASPSP;
            break;
            case PARTIALLY_AUTHORISED: consentStatus = ConsentStatus.PARTIALLY_AUTHORISED;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + scaStatusTO );
        }

        return consentStatus;
    }

    protected AccountReference accountReferenceTOToAccountReference(AccountReferenceTO accountReferenceTO) {
        if ( accountReferenceTO == null ) {
            return null;
        }

        AccountReference accountReference = new AccountReference();

        accountReference.setIban( accountReferenceTO.getIban() );

        return accountReference;
    }

    protected List<AccountReference> accountReferenceTOListToAccountReferenceList(List<AccountReferenceTO> list) {
        if ( list == null ) {
            return null;
        }

        List<AccountReference> list1 = new ArrayList<AccountReference>( list.size() );
        for ( AccountReferenceTO accountReferenceTO : list ) {
            list1.add( accountReferenceTOToAccountReference( accountReferenceTO ) );
        }

        return list1;
    }
}
