/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.web.mapper;

import de.adorsys.multibanking.domain.BankAccessEntity;
import de.adorsys.multibanking.domain.Consent;
import de.adorsys.multibanking.domain.ScaStatus;
import de.adorsys.multibanking.web.mapper.BankAccessMapper;
import de.adorsys.multibanking.web.mapper.BankAccessMapperImpl;
import de.adorsys.multibanking.web.model.BankAccessTO;
import de.adorsys.multibanking.web.model.ConsentTO;
import org.springframework.stereotype.Component;

@Component
public class BankAccessMapperImpl
implements BankAccessMapper {
    public BankAccessTO toBankAccessTO(BankAccessEntity bankAccessEntity) {
        if (bankAccessEntity == null) {
            return null;
        }
        BankAccessTO bankAccessTO = new BankAccessTO();
        bankAccessTO.setId(bankAccessEntity.getId());
        bankAccessTO.setBankCode(bankAccessEntity.getBankCode());
        bankAccessTO.setStorePin(bankAccessEntity.isStorePin());
        bankAccessTO.setStoreBookings(bankAccessEntity.isStoreBookings());
        bankAccessTO.setCategorizeBookings(bankAccessEntity.isCategorizeBookings());
        bankAccessTO.setStoreAnalytics(bankAccessEntity.isStoreAnalytics());
        bankAccessTO.setStoreAnonymizedBookings(bankAccessEntity.isStoreAnonymizedBookings());
        bankAccessTO.setProvideDataForMachineLearning(bankAccessEntity.isProvideDataForMachineLearning());
        bankAccessTO.setBankName(bankAccessEntity.getBankName());
        bankAccessTO.setIban(bankAccessEntity.getIban());
        bankAccessTO.setAllAcountsConsent(this.consentToConsentTO(bankAccessEntity.getAllAcountsConsent()));
        return bankAccessTO;
    }

    public BankAccessEntity toBankAccessEntity(BankAccessTO bankAccessTO) {
        if (bankAccessTO == null) {
            return null;
        }
        BankAccessEntity bankAccessEntity = new BankAccessEntity();
        bankAccessEntity.setBankName(bankAccessTO.getBankName());
        bankAccessEntity.setAllAcountsConsent(this.consentTOToConsent(bankAccessTO.getAllAcountsConsent()));
        bankAccessEntity.setBankLogin(bankAccessTO.getBankLogin());
        bankAccessEntity.setBankLogin2(bankAccessTO.getBankLogin2());
        bankAccessEntity.setBankCode(bankAccessTO.getBankCode());
        bankAccessEntity.setIban(bankAccessTO.getIban());
        bankAccessEntity.setId(bankAccessTO.getId());
        bankAccessEntity.setPin(bankAccessTO.getPin());
        bankAccessEntity.setPin2(bankAccessTO.getPin2());
        bankAccessEntity.setStorePin(bankAccessTO.isStorePin());
        bankAccessEntity.setStoreBookings(bankAccessTO.isStoreBookings());
        bankAccessEntity.setCategorizeBookings(bankAccessTO.isCategorizeBookings());
        bankAccessEntity.setStoreAnalytics(bankAccessTO.isStoreAnalytics());
        bankAccessEntity.setStoreAnonymizedBookings(bankAccessTO.isStoreAnonymizedBookings());
        bankAccessEntity.setProvideDataForMachineLearning(bankAccessTO.isProvideDataForMachineLearning());
        return bankAccessEntity;
    }

    protected ConsentTO.ScaStatusTO scaStatusToScaStatusTO(ScaStatus scaStatus) {
        ConsentTO.ScaStatusTO scaStatusTO;
        if (scaStatus == null) {
            return null;
        }
        switch (1.$SwitchMap$de$adorsys$multibanking$domain$ScaStatus[scaStatus.ordinal()]) {
            case 1: {
                scaStatusTO = ConsentTO.ScaStatusTO.STARTED;
                break;
            }
            case 2: {
                scaStatusTO = ConsentTO.ScaStatusTO.FINALISED;
                break;
            }
            case 3: {
                scaStatusTO = ConsentTO.ScaStatusTO.FAILED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + scaStatus);
            }
        }
        return scaStatusTO;
    }

    protected ConsentTO consentToConsentTO(Consent consent) {
        if (consent == null) {
            return null;
        }
        ConsentTO consentTO = new ConsentTO();
        consentTO.setConsentId(consent.getConsentId());
        consentTO.setAuthUrl(consent.getAuthUrl());
        consentTO.setScaStatus(this.scaStatusToScaStatusTO(consent.getScaStatus()));
        return consentTO;
    }

    protected ScaStatus scaStatusTOToScaStatus(ConsentTO.ScaStatusTO scaStatusTO) {
        ScaStatus scaStatus;
        if (scaStatusTO == null) {
            return null;
        }
        switch (1.$SwitchMap$de$adorsys$multibanking$web$model$ConsentTO$ScaStatusTO[scaStatusTO.ordinal()]) {
            case 1: {
                scaStatus = ScaStatus.STARTED;
                break;
            }
            case 2: {
                scaStatus = ScaStatus.FINALISED;
                break;
            }
            case 3: {
                scaStatus = ScaStatus.FAILED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + scaStatusTO);
            }
        }
        return scaStatus;
    }

    protected Consent consentTOToConsent(ConsentTO consentTO) {
        if (consentTO == null) {
            return null;
        }
        Consent consent = new Consent();
        consent.setConsentId(consentTO.getConsentId());
        consent.setAuthUrl(consentTO.getAuthUrl());
        consent.setScaStatus(this.scaStatusTOToScaStatus(consentTO.getScaStatus()));
        return consent;
    }
}

