/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.web.mapper;

import de.adorsys.multibanking.domain.AccountAnalyticsEntity;
import de.adorsys.multibanking.domain.BookingGroup;
import de.adorsys.multibanking.domain.BookingPeriod;
import de.adorsys.multibanking.domain.Contract;
import de.adorsys.multibanking.domain.Cycle;
import de.adorsys.multibanking.domain.ExecutedBooking;
import de.adorsys.multibanking.web.mapper.AnalyticsMapper;
import de.adorsys.multibanking.web.mapper.AnalyticsMapperImpl;
import de.adorsys.multibanking.web.model.AnalyticsTO;
import de.adorsys.multibanking.web.model.BookingGroupTO;
import de.adorsys.multibanking.web.model.BookingPeriodTO;
import de.adorsys.multibanking.web.model.ContractTO;
import de.adorsys.multibanking.web.model.CycleTO;
import de.adorsys.multibanking.web.model.ExecutedBookingTO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class AnalyticsMapperImpl
implements AnalyticsMapper {
    public AnalyticsTO toAnalyticsTO(AccountAnalyticsEntity analyticsEntity) {
        if (analyticsEntity == null) {
            return null;
        }
        AnalyticsTO analyticsTO = new AnalyticsTO();
        analyticsTO.setAnalyticsDate(analyticsEntity.getAnalyticsDate());
        analyticsTO.setBookingGroups(this.bookingGroupListToBookingGroupTOList(analyticsEntity.getBookingGroups()));
        return analyticsTO;
    }

    public ContractTO toContractTO(Contract contract) {
        if (contract == null) {
            return null;
        }
        ContractTO contractTO = new ContractTO();
        contractTO.setLogo(contract.getLogo());
        contractTO.setHomepage(contract.getHomepage());
        contractTO.setHotline(contract.getHotline());
        contractTO.setEmail(contract.getEmail());
        contractTO.setMandateReference(contract.getMandateReference());
        contractTO.setInterval(this.cycleToCycleTO(contract.getInterval()));
        contractTO.setCancelled(contract.isCancelled());
        contractTO.setAmount(contract.getAmount());
        contractTO.setMainCategory(contract.getMainCategory());
        contractTO.setSubCategory(contract.getSubCategory());
        contractTO.setSpecification(contract.getSpecification());
        contractTO.setProvider(contract.getProvider());
        return contractTO;
    }

    protected BookingGroupTO.Type typeToType(BookingGroup.Type type) {
        BookingGroupTO.Type type1;
        if (type == null) {
            return null;
        }
        switch (1.$SwitchMap$de$adorsys$multibanking$domain$BookingGroup$Type[type.ordinal()]) {
            case 1: {
                type1 = BookingGroupTO.Type.STANDING_ORDER;
                break;
            }
            case 2: {
                type1 = BookingGroupTO.Type.RECURRENT_INCOME;
                break;
            }
            case 3: {
                type1 = BookingGroupTO.Type.RECURRENT_SEPA;
                break;
            }
            case 4: {
                type1 = BookingGroupTO.Type.RECURRENT_NONSEPA;
                break;
            }
            case 5: {
                type1 = BookingGroupTO.Type.CUSTOM;
                break;
            }
            case 6: {
                type1 = BookingGroupTO.Type.OTHER_INCOME;
                break;
            }
            case 7: {
                type1 = BookingGroupTO.Type.OTHER_EXPENSES;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + type);
            }
        }
        return type1;
    }

    protected ExecutedBookingTO executedBookingToExecutedBookingTO(ExecutedBooking executedBooking) {
        if (executedBooking == null) {
            return null;
        }
        ExecutedBookingTO executedBookingTO = new ExecutedBookingTO();
        executedBookingTO.setBookingId(executedBooking.getBookingId());
        executedBookingTO.setExecutionDate(executedBooking.getExecutionDate());
        executedBookingTO.setExecuted(executedBooking.isExecuted());
        return executedBookingTO;
    }

    protected List<ExecutedBookingTO> executedBookingListToExecutedBookingTOList(List<ExecutedBooking> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ExecutedBookingTO> list1 = new ArrayList<ExecutedBookingTO>(list.size());
        for (ExecutedBooking executedBooking : list) {
            list1.add(this.executedBookingToExecutedBookingTO(executedBooking));
        }
        return list1;
    }

    protected BookingPeriodTO bookingPeriodToBookingPeriodTO(BookingPeriod bookingPeriod) {
        if (bookingPeriod == null) {
            return null;
        }
        BookingPeriodTO bookingPeriodTO = new BookingPeriodTO();
        bookingPeriodTO.setStart(bookingPeriod.getStart());
        bookingPeriodTO.setEnd(bookingPeriod.getEnd());
        bookingPeriodTO.setAmount(bookingPeriod.getAmount());
        bookingPeriodTO.setBookings(this.executedBookingListToExecutedBookingTOList(bookingPeriod.getBookings()));
        return bookingPeriodTO;
    }

    protected List<BookingPeriodTO> bookingPeriodListToBookingPeriodTOList(List<BookingPeriod> list) {
        if (list == null) {
            return null;
        }
        ArrayList<BookingPeriodTO> list1 = new ArrayList<BookingPeriodTO>(list.size());
        for (BookingPeriod bookingPeriod : list) {
            list1.add(this.bookingPeriodToBookingPeriodTO(bookingPeriod));
        }
        return list1;
    }

    protected BookingGroupTO bookingGroupToBookingGroupTO(BookingGroup bookingGroup) {
        if (bookingGroup == null) {
            return null;
        }
        BookingGroupTO bookingGroupTO = new BookingGroupTO();
        bookingGroupTO.setType(this.typeToType(bookingGroup.getType()));
        bookingGroupTO.setName(bookingGroup.getName());
        bookingGroupTO.setSalaryWage(bookingGroup.isSalaryWage());
        bookingGroupTO.setMainCategory(bookingGroup.getMainCategory());
        bookingGroupTO.setSubCategory(bookingGroup.getSubCategory());
        bookingGroupTO.setSpecification(bookingGroup.getSpecification());
        bookingGroupTO.setOtherAccount(bookingGroup.getOtherAccount());
        bookingGroupTO.setAmount(bookingGroup.getAmount());
        bookingGroupTO.setBookingPeriods(this.bookingPeriodListToBookingPeriodTOList(bookingGroup.getBookingPeriods()));
        bookingGroupTO.setContract(this.toContractTO(bookingGroup.getContract()));
        return bookingGroupTO;
    }

    protected List<BookingGroupTO> bookingGroupListToBookingGroupTOList(List<BookingGroup> list) {
        if (list == null) {
            return null;
        }
        ArrayList<BookingGroupTO> list1 = new ArrayList<BookingGroupTO>(list.size());
        for (BookingGroup bookingGroup : list) {
            list1.add(this.bookingGroupToBookingGroupTO(bookingGroup));
        }
        return list1;
    }

    protected CycleTO cycleToCycleTO(Cycle cycle) {
        CycleTO cycleTO;
        if (cycle == null) {
            return null;
        }
        switch (1.$SwitchMap$de$adorsys$multibanking$domain$Cycle[cycle.ordinal()]) {
            case 1: {
                cycleTO = CycleTO.WEEKLY;
                break;
            }
            case 2: {
                cycleTO = CycleTO.TWO_WEEKLY;
                break;
            }
            case 3: {
                cycleTO = CycleTO.MONTHLY;
                break;
            }
            case 4: {
                cycleTO = CycleTO.TWO_MONTHLY;
                break;
            }
            case 5: {
                cycleTO = CycleTO.QUARTERLY;
                break;
            }
            case 6: {
                cycleTO = CycleTO.HALF_YEARLY;
                break;
            }
            case 7: {
                cycleTO = CycleTO.YEARLY;
                break;
            }
            case 8: {
                cycleTO = CycleTO.INVALID;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + cycle);
            }
        }
        return cycleTO;
    }
}

