/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import de.adorsys.multibanking.domain.BankEntity;
import de.adorsys.multibanking.exception.ResourceNotFoundException;
import de.adorsys.multibanking.pers.spi.repository.BankRepositoryIf;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class BankService {
    private static final Logger log = LoggerFactory.getLogger(BankService.class);
    private final BankRepositoryIf bankRepository;

    public void importBanks(MultipartFile file) {
        try {
            this.importBanks(file.getInputStream());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void importBanks(File file) {
        try {
            this.importBanks((InputStream)new FileInputStream(file));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void importBanks(InputStream inputStream) throws IOException {
        log.info("start import banks file");
        YAMLFactory ymlFactory = new YAMLFactory();
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)ymlFactory).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        List banks = (List)objectMapper.readValue(inputStream, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        this.bankRepository.deleteAll();
        this.bankRepository.save((Iterable)banks);
        log.info("successfully imported [{}]", (Object)banks.size());
    }

    public BankEntity findBank(String bankCode) {
        return (BankEntity)this.bankRepository.findByBankCode(bankCode).orElseThrow(() -> new ResourceNotFoundException(BankEntity.class, bankCode));
    }

    public List<BankEntity> search(String terms) {
        return this.bankRepository.search(terms);
    }

    String findBankingUrl(String bankCode) {
        return this.bankRepository.findBankingUrl(bankCode).orElse(null);
    }

    public BankService(BankRepositoryIf bankRepository) {
        this.bankRepository = bankRepository;
    }
}

