/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.web;

import de.adorsys.multibanking.domain.BankAccessEntity;
import de.adorsys.multibanking.domain.BankAccountEntity;
import de.adorsys.multibanking.domain.SinglePaymentEntity;
import de.adorsys.multibanking.exception.PaymentException;
import de.adorsys.multibanking.exception.ResourceNotFoundException;
import de.adorsys.multibanking.pers.spi.repository.BankAccessRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.BankAccountRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.SinglePaymentRepositoryIf;
import de.adorsys.multibanking.service.PaymentService;
import de.adorsys.multibanking.web.PaymentController;
import de.adorsys.multibanking.web.UserResource;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.security.Principal;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@UserResource
@RestController
@RequestMapping(path={"api/v1/bankaccesses/{accessId}/accounts/{accountId}/payments"})
public class PaymentController {
    private final BankAccessRepositoryIf bankAccessRepository;
    private final BankAccountRepositoryIf bankAccountRepository;
    private final SinglePaymentRepositoryIf paymentRepository;
    private final PaymentService paymentService;
    private final Principal principal;

    @ApiOperation(value="Read payment", authorizations={@Authorization(value="multibanking_auth", scopes={@AuthorizationScope(scope="openid", description="")})})
    @GetMapping(value={"/{paymentId}"})
    public Resource<SinglePaymentEntity> getPayment(@PathVariable String accessId, @PathVariable String accountId, @PathVariable String paymentId) {
        SinglePaymentEntity paymentEntity = (SinglePaymentEntity)this.paymentRepository.findByUserIdAndId(this.principal.getName(), paymentId).orElseThrow(() -> new ResourceNotFoundException(SinglePaymentEntity.class, paymentId));
        return this.mapToResource(accessId, accountId, paymentEntity);
    }

    @ApiOperation(value="Create new payment", authorizations={@Authorization(value="multibanking_auth", scopes={@AuthorizationScope(scope="openid", description="")})})
    @PostMapping
    public HttpEntity<Void> createPayment(@PathVariable String accessId, @PathVariable String accountId, @RequestBody CreatePaymentRequest paymentRequest) {
        String pin;
        BankAccessEntity bankAccessEntity = (BankAccessEntity)this.bankAccessRepository.findByUserIdAndId(this.principal.getName(), accessId).orElseThrow(() -> new ResourceNotFoundException(BankAccessEntity.class, accessId));
        this.bankAccountRepository.findByUserIdAndId(this.principal.getName(), accountId).orElseThrow(() -> new ResourceNotFoundException(BankAccountEntity.class, accountId));
        String string = pin = paymentRequest.getPin() != null ? paymentRequest.getPin() : bankAccessEntity.getPin();
        if (pin == null) {
            throw new PaymentException("required pin not specified");
        }
        SinglePaymentEntity payment = this.paymentService.createSinglePayment(bankAccessEntity, paymentRequest.getTanTransportType(), paymentRequest.getPin(), paymentRequest.getPayment());
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(ControllerLinkBuilder.linkTo((Object)((PaymentController)ControllerLinkBuilder.methodOn(PaymentController.class, (Object[])new Object[0])).getPayment(accessId, accountId, payment.getId())).toUri());
        return new ResponseEntity((MultiValueMap)headers, HttpStatus.CREATED);
    }

    @ApiOperation(value="Submit payment", authorizations={@Authorization(value="multibanking_auth", scopes={@AuthorizationScope(scope="openid", description="")})})
    @PostMapping(value={"/{paymentId}/submit"})
    public HttpEntity<Void> submitPayment(@PathVariable String accessId, @PathVariable String accountId, @PathVariable String paymentId, @RequestBody SubmitPaymentRequest paymentRequest) {
        BankAccessEntity bankAccessEntity = (BankAccessEntity)this.bankAccessRepository.findByUserIdAndId(this.principal.getName(), accessId).orElseThrow(() -> new ResourceNotFoundException(BankAccessEntity.class, accessId));
        if (!this.bankAccountRepository.exists(accountId)) {
            throw new ResourceNotFoundException(BankAccountEntity.class, accountId);
        }
        SinglePaymentEntity paymentEntity = (SinglePaymentEntity)this.paymentRepository.findByUserIdAndId(this.principal.getName(), paymentId).orElseThrow(() -> new ResourceNotFoundException(SinglePaymentEntity.class, paymentId));
        this.paymentService.submitSinglePayment(paymentEntity, bankAccessEntity, paymentRequest.getPin(), paymentRequest.getTan());
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    private Resource<SinglePaymentEntity> mapToResource(@PathVariable String accessId, @PathVariable String accountId, SinglePaymentEntity paymentEntity) {
        return new Resource((Object)paymentEntity, new Link[]{ControllerLinkBuilder.linkTo((Object)((PaymentController)ControllerLinkBuilder.methodOn(PaymentController.class, (Object[])new Object[0])).getPayment(accessId, accountId, paymentEntity.getId())).withSelfRel()});
    }

    public PaymentController(BankAccessRepositoryIf bankAccessRepository, BankAccountRepositoryIf bankAccountRepository, SinglePaymentRepositoryIf paymentRepository, PaymentService paymentService, Principal principal) {
        this.bankAccessRepository = bankAccessRepository;
        this.bankAccountRepository = bankAccountRepository;
        this.paymentRepository = paymentRepository;
        this.paymentService = paymentService;
        this.principal = principal;
    }
}

