/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.web;

import de.adorsys.multibanking.domain.BankAccessEntity;
import de.adorsys.multibanking.domain.BankAccountEntity;
import de.adorsys.multibanking.domain.Consent;
import de.adorsys.multibanking.domain.UserEntity;
import de.adorsys.multibanking.exception.ExternalAuthorisationRequiredException;
import de.adorsys.multibanking.exception.ResourceNotFoundException;
import de.adorsys.multibanking.pers.spi.repository.BankAccessRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.BankAccountRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.UserRepositoryIf;
import de.adorsys.multibanking.service.BankAccountService;
import de.adorsys.multibanking.service.BookingService;
import de.adorsys.multibanking.web.DirectAccessController;
import de.adorsys.multibanking.web.UserResource;
import de.adorsys.multibanking.web.mapper.BalancesMapper;
import de.adorsys.multibanking.web.mapper.BankAccessMapper;
import de.adorsys.multibanking.web.mapper.BankAccountMapper;
import de.adorsys.multibanking.web.mapper.BankApiMapper;
import de.adorsys.multibanking.web.mapper.BookingMapper;
import de.adorsys.multibanking.web.mapper.ConsentMapper;
import de.adorsys.multibanking.web.model.BankAccessTO;
import de.adorsys.multibanking.web.model.BankApiTO;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@UserResource
@RestController
@RequestMapping(path={"api/v1/direct"})
public class DirectAccessController {
    private final BookingMapper bookingMapper;
    private final BankApiMapper bankApiMapper;
    private final BalancesMapper balancesMapper;
    private final ConsentMapper consentMapper;
    private final BankAccessMapper bankAccessMapper;
    private final BankAccountMapper bankAccountMapper;
    private final BankAccountService bankAccountService;
    private final BookingService bookingService;
    private final UserRepositoryIf userRepository;
    private final BankAccountRepositoryIf bankAccountRepository;
    private final BankAccessRepositoryIf bankAccessRepository;
    @Value(value="${threshold_temporaryData:15}")
    private Integer thresholdTemporaryData;

    @ApiOperation(value="Read bank accounts")
    @ApiResponses(value={@ApiResponse(code=200, message="Response", response=LoadBankAccountsResponse.class), @ApiResponse(code=202, message="Consent authorisation required", response=Consent.class)})
    @PutMapping(value={"/accounts"})
    public ResponseEntity<LoadBankAccountsResponse> loadBankAccounts(@RequestBody BankAccessTO bankAccess, @RequestParam(required=false) BankApiTO bankApi) {
        UserEntity userEntity = new UserEntity();
        userEntity.setId(UUID.randomUUID().toString());
        userEntity.setExpireUser(LocalDateTime.now().plusMinutes(this.thresholdTemporaryData.intValue()));
        this.userRepository.save(userEntity);
        BankAccessEntity bankAccessEntity = this.bankAccessMapper.toBankAccessEntity(bankAccess);
        bankAccessEntity.setStorePin(false);
        bankAccessEntity.setUserId(userEntity.getId());
        LoadBankAccountsResponse response = new LoadBankAccountsResponse();
        try {
            List bankAccounts = this.bankAccountService.loadBankAccountsOnline(bankAccessEntity, this.bankApiMapper.toBankApi(bankApi));
            bankAccessEntity.setPin(null);
            bankAccessEntity.setTemporary(true);
            bankAccessEntity.setUserId(userEntity.getId());
            this.bankAccessRepository.save(bankAccessEntity);
            bankAccounts.forEach(account -> {
                account.setBankAccessId(bankAccessEntity.getId());
                this.bankAccountRepository.save(account);
            });
            response.setBankAccounts(this.bankAccountMapper.toBankAccountTOs(bankAccounts));
            return new ResponseEntity((Object)response, HttpStatus.OK);
        }
        catch (ExternalAuthorisationRequiredException e) {
            response.setConsent(e.getConsent());
            return new ResponseEntity((Object)response, HttpStatus.ACCEPTED);
        }
    }

    @ApiResponses(value={@ApiResponse(code=202, message="Consent authorisation required", response=Consent.class)})
    @ApiOperation(value="Read account bookings")
    @PutMapping(value={"/bookings"})
    public ResponseEntity<LoadBookingsResponse> loadBookings(@RequestBody LoadBookingsRequest loadBookingsRequest, @RequestParam(required=false) BankApiTO bankApi) {
        BankAccessEntity bankAccessEntity = (BankAccessEntity)this.bankAccessRepository.findOne(loadBookingsRequest.getAccessId()).orElseThrow(() -> new ResourceNotFoundException(BankAccessEntity.class, loadBookingsRequest.getAccessId()));
        BankAccountEntity bankAccountEntity = (BankAccountEntity)this.bankAccountRepository.findOne(loadBookingsRequest.getAccountId()).orElseThrow(() -> new ResourceNotFoundException(BankAccountEntity.class, loadBookingsRequest.getAccountId()));
        LoadBookingsResponse loadBookingsResponse = new LoadBookingsResponse();
        try {
            List bookings = this.bookingService.syncBookings(bankAccessEntity, bankAccountEntity, this.bankApiMapper.toBankApi(bankApi), loadBookingsRequest.getPin());
            loadBookingsResponse.setBookings(this.bookingMapper.toBookingTOs((Iterable)bookings));
            loadBookingsResponse.setBalances(this.balancesMapper.toBalancesReportTO(bankAccountEntity.getBalances()));
            return new ResponseEntity((Object)loadBookingsResponse, HttpStatus.OK);
        }
        catch (ExternalAuthorisationRequiredException e) {
            loadBookingsResponse.setConsent(this.consentMapper.toConsentTO(e.getConsent()));
            return new ResponseEntity((Object)loadBookingsResponse, HttpStatus.ACCEPTED);
        }
    }

    public DirectAccessController(BookingMapper bookingMapper, BankApiMapper bankApiMapper, BalancesMapper balancesMapper, ConsentMapper consentMapper, BankAccessMapper bankAccessMapper, BankAccountMapper bankAccountMapper, BankAccountService bankAccountService, BookingService bookingService, UserRepositoryIf userRepository, BankAccountRepositoryIf bankAccountRepository, BankAccessRepositoryIf bankAccessRepository) {
        this.bookingMapper = bookingMapper;
        this.bankApiMapper = bankApiMapper;
        this.balancesMapper = balancesMapper;
        this.consentMapper = consentMapper;
        this.bankAccessMapper = bankAccessMapper;
        this.bankAccountMapper = bankAccountMapper;
        this.bankAccountService = bankAccountService;
        this.bookingService = bookingService;
        this.userRepository = userRepository;
        this.bankAccountRepository = bankAccountRepository;
        this.bankAccessRepository = bankAccessRepository;
    }
}

