/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.web;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import de.adorsys.multibanking.domain.RuleEntity;
import de.adorsys.multibanking.exception.ResourceNotFoundException;
import de.adorsys.multibanking.pers.spi.repository.BookingRuleRepositoryIf;
import de.adorsys.multibanking.service.analytics.AnalyticsService;
import de.adorsys.multibanking.web.UserResource;
import de.adorsys.multibanking.web.mapper.RuleMapper;
import de.adorsys.multibanking.web.model.RuleTO;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@UserResource
@RestController
@RequestMapping(path={"api/v1/analytics/rules"})
public class CustomRulesController {
    private static final Logger log = LoggerFactory.getLogger(CustomRulesController.class);
    private final RuleMapper ruleMapper;
    private final AnalyticsService analyticsService;
    private final BookingRuleRepositoryIf rulesRepository;

    @ApiOperation(value="Create user custom rule", authorizations={@Authorization(value="multibanking_auth", scopes={@AuthorizationScope(scope="openid", description="")})})
    @PostMapping
    public HttpEntity<Void> createRule(@RequestBody RuleTO rule) {
        this.analyticsService.createCustomRule(this.ruleMapper.toRuleEntity(rule));
        return new ResponseEntity(HttpStatus.CREATED);
    }

    @ApiOperation(value="Read user custom rule", authorizations={@Authorization(value="multibanking_auth", scopes={@AuthorizationScope(scope="openid", description="")})})
    @GetMapping(value={"{ruleId}"})
    public Resource<RuleTO> getRule(@PathVariable String ruleId) {
        RuleEntity ruleEntity = (RuleEntity)this.rulesRepository.findByRuleId(ruleId).orElseThrow(() -> new ResourceNotFoundException(RuleEntity.class, ruleId));
        return this.mapToResource(ruleEntity);
    }

    @ApiOperation(value="Update user custom rule", authorizations={@Authorization(value="multibanking_auth", scopes={@AuthorizationScope(scope="openid", description="")})})
    @PutMapping(value={"{ruleId}"})
    public HttpEntity<Void> updateRule(@PathVariable String ruleId, @RequestBody RuleTO rule) {
        this.analyticsService.updateCustomRule(this.ruleMapper.toRuleEntity(rule));
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @ApiOperation(value="Delete user custom rule", authorizations={@Authorization(value="multibanking_auth", scopes={@AuthorizationScope(scope="openid", description="")})})
    @DeleteMapping(value={"{ruleId}"})
    public HttpEntity<Void> deleteRule(@PathVariable String ruleId) {
        this.analyticsService.deleteRule(ruleId);
        log.info("Rule [{}] deleted.", (Object)ruleId);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @ApiOperation(value="Read user custom rules", authorizations={@Authorization(value="multibanking_auth", scopes={@AuthorizationScope(scope="openid", description="")})})
    @GetMapping
    public Resources<Resource<RuleTO>> getRules(@PageableDefault(size=20) Pageable pageable, PagedResourcesAssembler<RuleTO> assembler) {
        Page pageableResult = this.rulesRepository.findAllPageable(pageable);
        return assembler.toResource(pageableResult.map(arg_0 -> ((RuleMapper)this.ruleMapper).toRuleTO(arg_0)));
    }

    @ApiOperation(value="Search user custom rules", authorizations={@Authorization(value="multibanking_auth", scopes={@AuthorizationScope(scope="openid", description="")})})
    @GetMapping(value={"/search"})
    public Resources<Resource<RuleTO>> searchRules(@RequestParam String query) {
        return new Resources((Iterable)this.mapToResources(this.rulesRepository.search(query)), new Link[0]);
    }

    @ApiOperation(value="Download user custom rules", authorizations={@Authorization(value="multibanking_auth", scopes={@AuthorizationScope(scope="openid", description="")})})
    @GetMapping(path={"/download"}, produces={"application/octet-stream"})
    public HttpEntity<InputStreamResource> downloadRules() throws JsonProcessingException {
        List rules = this.ruleMapper.toRuleTOs(this.rulesRepository.findAll());
        YAMLFactory ymlFactory = new YAMLFactory();
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)ymlFactory);
        return ResponseEntity.ok().body((Object)new InputStreamResource((InputStream)new ByteArrayInputStream(objectMapper.writeValueAsBytes((Object)rules))));
    }

    private List<Resource<RuleTO>> mapToResources(List<RuleEntity> entities) {
        return entities.stream().map(arg_0 -> this.mapToResource(arg_0)).collect(Collectors.toList());
    }

    private Resource<RuleTO> mapToResource(RuleEntity entity) {
        return new Resource((Object)this.ruleMapper.toRuleTO(entity), new Link[]{ControllerLinkBuilder.linkTo((Object)((CustomRulesController)ControllerLinkBuilder.methodOn(CustomRulesController.class, (Object[])new Object[0])).getRule(entity.getId())).withSelfRel()});
    }

    public CustomRulesController(RuleMapper ruleMapper, AnalyticsService analyticsService, BookingRuleRepositoryIf rulesRepository) {
        this.ruleMapper = ruleMapper;
        this.analyticsService = analyticsService;
        this.rulesRepository = rulesRepository;
    }
}

