/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service;

import de.adorsys.multibanking.domain.BankAccess;
import de.adorsys.multibanking.domain.BankAccessEntity;
import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.BankApiUser;
import de.adorsys.multibanking.domain.UserEntity;
import de.adorsys.multibanking.domain.spi.OnlineBankingService;
import de.adorsys.multibanking.exception.ResourceNotFoundException;
import de.adorsys.multibanking.pers.spi.repository.UserRepositoryIf;
import de.adorsys.multibanking.service.BankService;
import de.adorsys.multibanking.service.OnlineBankingServiceProducer;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class UserService {
    private final UserRepositoryIf userRepository;
    private final BankService bankService;
    private final OnlineBankingServiceProducer bankingServiceProducer;

    BankApiUser checkApiRegistration(BankAccessEntity bankAccess, BankApi bankApi) {
        OnlineBankingService onlineBankingService;
        OnlineBankingService onlineBankingService2 = onlineBankingService = bankApi != null ? this.bankingServiceProducer.getBankingService(bankApi) : this.bankingServiceProducer.getBankingService(bankAccess.getBankCode());
        if (onlineBankingService.userRegistrationRequired()) {
            UserEntity userEntity = (UserEntity)this.userRepository.findById(bankAccess.getUserId()).orElseThrow(() -> new ResourceNotFoundException(UserEntity.class, bankAccess.getUserId()));
            return userEntity.getApiUser().stream().filter(bankApiUser -> bankApiUser.getBankApi() == onlineBankingService.bankApi()).findFirst().orElseGet(() -> this.registerUser(bankAccess, onlineBankingService, userEntity));
        }
        BankApiUser bankApiUser2 = new BankApiUser();
        bankApiUser2.setBankApi(onlineBankingService.bankApi());
        return bankApiUser2;
    }

    private BankApiUser registerUser(BankAccessEntity bankAccess, OnlineBankingService onlineBankingService, UserEntity userEntity) {
        BankApiUser bankApiUser = onlineBankingService.registerUser(this.bankService.findBankingUrl(bankAccess.getBankCode()), (BankAccess)bankAccess, bankAccess.getPin());
        userEntity.getApiUser().add(bankApiUser);
        this.userRepository.save(userEntity);
        return bankApiUser;
    }

    void checkUserExists(String userId) {
        if (!this.userRepository.exists(userId)) {
            UserEntity userEntity = new UserEntity();
            userEntity.setApiUser(new ArrayList());
            userEntity.setId(userId);
            this.userRepository.save(userEntity);
        }
    }

    void updataeBankApiUser(String userId, BankApiUser bankApiUser) {
        UserEntity userEntity = (UserEntity)this.userRepository.findById(userId).orElseThrow(() -> new ResourceNotFoundException(UserEntity.class, userId));
        userEntity.setApiUser(userEntity.getApiUser().stream().filter(bau -> bau.getBankApi() != bankApiUser.getBankApi()).collect(Collectors.toList()));
        userEntity.getApiUser().add(bankApiUser);
        this.userRepository.save(userEntity);
    }

    Optional<LocalDateTime> getRulesLastChangeDate(String userId) {
        return this.userRepository.getRulesLastChangeDate(userId);
    }

    public UserService(UserRepositoryIf userRepository, BankService bankService, OnlineBankingServiceProducer bankingServiceProducer) {
        this.userRepository = userRepository;
        this.bankService = bankService;
        this.bankingServiceProducer = bankingServiceProducer;
    }
}

