/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service;

import de.adorsys.multibanking.config.FinTSProductConfig;
import de.adorsys.multibanking.domain.AbstractScaTransaction;
import de.adorsys.multibanking.domain.BankAccess;
import de.adorsys.multibanking.domain.BankAccessEntity;
import de.adorsys.multibanking.domain.BankApiUser;
import de.adorsys.multibanking.domain.BankEntity;
import de.adorsys.multibanking.domain.StandingOrder;
import de.adorsys.multibanking.domain.StandingOrderEntity;
import de.adorsys.multibanking.domain.exception.MultibankingException;
import de.adorsys.multibanking.domain.request.SubmitAuthorizationCodeRequest;
import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.response.AuthorisationCodeResponse;
import de.adorsys.multibanking.domain.spi.OnlineBankingService;
import de.adorsys.multibanking.exception.PaymentException;
import de.adorsys.multibanking.exception.domain.MissingPinException;
import de.adorsys.multibanking.pers.spi.repository.StandingOrderRepositoryIf;
import de.adorsys.multibanking.service.BankService;
import de.adorsys.multibanking.service.OnlineBankingServiceProducer;
import de.adorsys.multibanking.service.UserService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class StandingOrderService {
    private static final Logger log = LoggerFactory.getLogger(StandingOrderService.class);
    private final BankService bankService;
    private final UserService userService;
    private final StandingOrderRepositoryIf standingOrderRepository;
    private final OnlineBankingServiceProducer bankingServiceProducer;
    private final FinTSProductConfig finTSProductConfig;

    Object createStandingOrder(BankAccessEntity bankAccess, String pin, StandingOrder standingOrder) {
        OnlineBankingService bankingService = this.bankingServiceProducer.getBankingService(bankAccess.getBankCode());
        BankApiUser bankApiUser = this.userService.checkApiRegistration(bankAccess, bankingService.bankApi());
        String string = pin = pin == null ? bankAccess.getPin() : pin;
        if (pin == null) {
            throw new MissingPinException();
        }
        BankEntity bankEntity = this.bankService.findBank(bankAccess.getBankCode());
        try {
            TransactionRequest request = TransactionRequest.builder().bankApiUser(bankApiUser).transaction((AbstractScaTransaction)standingOrder).bankAccess((BankAccess)bankAccess).pin(pin).bankCode(bankEntity.getBlzHbci()).build();
            request.setProduct(this.finTSProductConfig.getProduct());
            AuthorisationCodeResponse tanSubmit = bankingService.requestAuthorizationCode(bankEntity.getBankingUrl(), request);
            StandingOrderEntity target = new StandingOrderEntity();
            BeanUtils.copyProperties((Object)standingOrder, (Object)target);
            target.setCreatedDateTime(new Date());
            target.setUserId(bankAccess.getUserId());
            target.setTanSubmitExternal((Object)tanSubmit);
            this.standingOrderRepository.save(target);
            return tanSubmit;
        }
        catch (MultibankingException e) {
            throw new PaymentException(e.getMessage());
        }
    }

    void submitStandingOrder(StandingOrder standingOrder, Object tanSubmit, BankAccessEntity bankAccess, String pin, String tan) {
        OnlineBankingService bankingService = this.bankingServiceProducer.getBankingService(bankAccess.getBankCode());
        String string = pin = pin == null ? bankAccess.getPin() : pin;
        if (pin == null) {
            throw new MissingPinException();
        }
        try {
            SubmitAuthorizationCodeRequest request = SubmitAuthorizationCodeRequest.builder().sepaTransaction((AbstractScaTransaction)standingOrder).tanSubmit(tanSubmit).pin(pin).tan(tan).build();
            request.setProduct(this.finTSProductConfig.getProduct());
            bankingService.submitAuthorizationCode(request);
        }
        catch (MultibankingException e) {
            throw new PaymentException(e.getMessage());
        }
    }

    public StandingOrderService(BankService bankService, UserService userService, StandingOrderRepositoryIf standingOrderRepository, OnlineBankingServiceProducer bankingServiceProducer, FinTSProductConfig finTSProductConfig) {
        this.bankService = bankService;
        this.userService = userService;
        this.standingOrderRepository = standingOrderRepository;
        this.bankingServiceProducer = bankingServiceProducer;
        this.finTSProductConfig = finTSProductConfig;
    }
}

