/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service;

import de.adorsys.multibanking.bg.BankingGatewayAdapter;
import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.BankEntity;
import de.adorsys.multibanking.domain.spi.OnlineBankingService;
import de.adorsys.multibanking.figo.FigoBanking;
import de.adorsys.multibanking.finapi.FinapiBanking;
import de.adorsys.multibanking.hbci.Hbci4JavaBanking;
import de.adorsys.multibanking.mock.MockBanking;
import de.adorsys.multibanking.pers.spi.repository.BankRepositoryIf;
import de.adorsys.multibanking.service.OnlineBankingServiceProducer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OnlineBankingServiceProducer {
    private final BankRepositoryIf bankRepository;
    @Value(value="${defaultBankApi:HBCI}")
    private String defaultBankApi;
    private Hbci4JavaBanking hbci4JavaBanking = new Hbci4JavaBanking(true);
    private FigoBanking figoBanking = new FigoBanking(BankApi.FIGO);
    private FigoBanking figoBankingAlternative = new FigoBanking(BankApi.FIGO_ALTERNATIVE);
    private FinapiBanking finapiBanking = new FinapiBanking();
    private MockBanking mockBanking = new MockBanking();
    private BankingGatewayAdapter xs2ABanking = new BankingGatewayAdapter();

    private BankApi getBankApiForBlz(String blz) {
        BankEntity bankInfoEntity = this.bankRepository.findByBankCode(blz).orElse(null);
        if (bankInfoEntity != null && bankInfoEntity.getBankApi() != null) {
            return bankInfoEntity.getBankApi();
        }
        return BankApi.valueOf((String)this.defaultBankApi);
    }

    public OnlineBankingService getBankingService(String bankCode) {
        BankApi bankApi = this.getBankApiForBlz(bankCode);
        return this.getBankingService(bankApi);
    }

    public OnlineBankingService getBankingService(BankApi bankApi) {
        switch (1.$SwitchMap$de$adorsys$multibanking$domain$BankApi[bankApi.ordinal()]) {
            case 1: {
                return this.hbci4JavaBanking;
            }
            case 2: {
                return this.figoBanking;
            }
            case 3: {
                return this.figoBankingAlternative;
            }
            case 4: {
                return this.finapiBanking;
            }
            case 5: 
            case 6: {
                return this.xs2ABanking;
            }
            case 7: {
                return this.mockBanking;
            }
        }
        throw new IllegalStateException("unsupported bank api");
    }

    public OnlineBankingServiceProducer(BankRepositoryIf bankRepository) {
        this.bankRepository = bankRepository;
    }
}

