/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service;

import de.adorsys.multibanking.config.FinTSProductConfig;
import de.adorsys.multibanking.domain.BankAccess;
import de.adorsys.multibanking.domain.BankAccessEntity;
import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.BankAccountEntity;
import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.BankApiUser;
import de.adorsys.multibanking.domain.BankEntity;
import de.adorsys.multibanking.domain.Consent;
import de.adorsys.multibanking.domain.ScaStatus;
import de.adorsys.multibanking.domain.exception.MultibankingError;
import de.adorsys.multibanking.domain.exception.MultibankingException;
import de.adorsys.multibanking.domain.request.CreateConsentRequest;
import de.adorsys.multibanking.domain.request.LoadAccountInformationRequest;
import de.adorsys.multibanking.domain.response.CreateConsentResponse;
import de.adorsys.multibanking.domain.spi.OnlineBankingService;
import de.adorsys.multibanking.exception.BankAccessAlreadyExistException;
import de.adorsys.multibanking.exception.ExternalAuthorisationRequiredException;
import de.adorsys.multibanking.exception.InvalidBankAccessException;
import de.adorsys.multibanking.exception.InvalidPinException;
import de.adorsys.multibanking.exception.ResourceNotFoundException;
import de.adorsys.multibanking.pers.spi.repository.BankAccessRepositoryIf;
import de.adorsys.multibanking.pers.spi.repository.BankAccountRepositoryIf;
import de.adorsys.multibanking.service.BankService;
import de.adorsys.multibanking.service.OnlineBankingServiceProducer;
import de.adorsys.multibanking.service.UserService;
import java.security.Principal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class BankAccountService {
    private static final Logger log = LoggerFactory.getLogger(BankAccountService.class);
    private final BankAccessRepositoryIf bankAccessRepository;
    private final BankAccountRepositoryIf bankAccountRepository;
    private final OnlineBankingServiceProducer bankingServiceProducer;
    private final UserService userService;
    private final BankService bankService;
    private final Principal principal;
    private final FinTSProductConfig finTSProductConfig;

    public List<BankAccountEntity> getBankAccounts(String userId, String accessId) {
        ScaStatus scaStatusStarted;
        BankAccessEntity bankAccessEntity = (BankAccessEntity)this.bankAccessRepository.findByUserIdAndId(userId, accessId).orElseThrow(() -> new ResourceNotFoundException(BankAccessEntity.class, accessId));
        List bankAccounts = this.bankAccountRepository.findByUserIdAndBankAccessId(userId, accessId);
        if (bankAccounts.isEmpty() && (scaStatusStarted = (ScaStatus)Optional.ofNullable(bankAccessEntity.getAllAcountsConsent()).map(Consent::getScaStatus).filter(status -> status == ScaStatus.STARTED).orElse(null)) != null) {
            try {
                bankAccounts = this.loadBankAccountsOnline(bankAccessEntity, null);
                bankAccounts.forEach(account -> account.setBankAccessId(bankAccessEntity.getId()));
                this.bankAccountRepository.save(bankAccounts);
                log.info("[{}] accounts for connection [{}] created.", (Object)bankAccounts.size(), (Object)bankAccessEntity.getId());
                bankAccessEntity.getAllAcountsConsent().setScaStatus(ScaStatus.FINALISED);
                this.bankAccessRepository.save(bankAccessEntity);
            }
            catch (ExternalAuthorisationRequiredException e) {
                bankAccessEntity.setAllAcountsConsent(e.getConsent());
                this.bankAccessRepository.save(bankAccessEntity);
                throw e;
            }
        }
        return bankAccounts;
    }

    private void checkAvailableAccountsConsent(BankAccessEntity bankAccess, OnlineBankingService onlineBankingService, BankApiUser bankApiUser, BankEntity bankEntity) {
        if (onlineBankingService.accountInformationConsentRequired() && bankAccess.getAllAcountsConsent() == null) {
            throw new ExternalAuthorisationRequiredException(this.createAvailableAccountsConsent(onlineBankingService, bankApiUser, bankAccess, bankEntity));
        }
    }

    public List<BankAccountEntity> loadBankAccountsOnline(BankAccessEntity bankAccess, BankApi bankApi) {
        OnlineBankingService onlineBankingService = bankApi != null ? this.bankingServiceProducer.getBankingService(bankApi) : this.bankingServiceProducer.getBankingService(bankAccess.getBankCode());
        this.checkBankSupported(bankAccess, onlineBankingService);
        BankApiUser bankApiUser = this.userService.checkApiRegistration(bankAccess, bankApi);
        BankEntity bankEntity = this.bankService.findBank(bankAccess.getBankCode());
        this.checkAvailableAccountsConsent(bankAccess, onlineBankingService, bankApiUser, bankEntity);
        List bankAccounts = this.loadBankAccountsOnline(bankAccess, onlineBankingService, bankApiUser, bankEntity);
        if (onlineBankingService.bankApi() == BankApi.FIGO) {
            this.filterAccounts(bankAccess, onlineBankingService, bankAccounts);
        }
        return Optional.ofNullable(bankAccounts).map(Collection::stream).orElseGet(Stream::empty).map(source -> {
            BankAccountEntity target = new BankAccountEntity();
            BeanUtils.copyProperties((Object)source, (Object)target);
            target.setUserId(bankAccess.getUserId());
            return target;
        }).collect(Collectors.toList());
    }

    private Consent createAvailableAccountsConsent(OnlineBankingService onlineBankingService, BankApiUser bankApiUser, BankAccessEntity bankAccessEntity, BankEntity bankEntity) {
        bankApiUser.setApiUserId(this.principal.getName());
        CreateConsentRequest createConsentRequest = CreateConsentRequest.builder().bankAccess((BankAccess)bankAccessEntity).bankApiUser(bankApiUser).availableAccountsConsent(true).frequencyPerDay(1).validUntil(LocalDate.now().plusDays(1L)).recurringIndicator(false).build();
        CreateConsentResponse accountInformationConsent = onlineBankingService.createAccountInformationConsent(bankEntity.getBankingUrl(), createConsentRequest);
        return this.toConsent(accountInformationConsent);
    }

    void checkDedicatedConsent(BankAccessEntity bankAccess, BankAccountEntity bankAccount, BankApiUser bankApiUser, OnlineBankingService onlineBankingService, BankEntity bankEntity) {
        if (onlineBankingService.accountInformationConsentRequired() && bankAccount.getDedicatedConsent() == null) {
            throw new ExternalAuthorisationRequiredException(this.createDedicatedConsent(onlineBankingService, bankApiUser, bankAccess, bankAccount, bankEntity));
        }
    }

    Consent createDedicatedConsent(OnlineBankingService onlineBankingService, BankApiUser bankApiUser, BankAccessEntity bankAccessEntity, BankAccountEntity bankAccountEntity, BankEntity bankEntity) {
        bankApiUser.setApiUserId(this.principal.getName());
        CreateConsentRequest createConsentRequest = CreateConsentRequest.builder().bankAccess((BankAccess)bankAccessEntity).accounts(Collections.singletonList(bankAccountEntity)).balances(Collections.singletonList(bankAccountEntity)).transactions(Collections.singletonList(bankAccountEntity)).bankApiUser(bankApiUser).frequencyPerDay(5).validUntil(LocalDate.now().plusYears(1L)).recurringIndicator(true).build();
        CreateConsentResponse accountInformationConsent = onlineBankingService.createAccountInformationConsent(bankEntity.getBankingUrl(), createConsentRequest);
        return this.toConsent(accountInformationConsent);
    }

    private List<BankAccount> loadBankAccountsOnline(BankAccessEntity bankAccess, OnlineBankingService onlineBankingService, BankApiUser bankApiUser, BankEntity bankEntity) {
        try {
            LoadAccountInformationRequest request = LoadAccountInformationRequest.builder().consentId(bankAccess.getAllAcountsConsent() != null ? bankAccess.getAllAcountsConsent().getConsentId() : null).bankApiUser(bankApiUser).bankAccess((BankAccess)bankAccess).bankCode(bankEntity.getBlzHbci()).pin(bankAccess.getPin()).storePin(bankAccess.isStorePin()).updateTanTransportTypes(true).build();
            request.setProduct(this.finTSProductConfig.getProduct());
            return onlineBankingService.loadBankAccounts(bankEntity.getBankingUrl(), request).getBankAccounts();
        }
        catch (MultibankingException e) {
            return this.handleMultibankingException(bankAccess, bankApiUser, onlineBankingService, bankEntity, e);
        }
    }

    private List<BankAccount> handleMultibankingException(BankAccessEntity bankAccess, BankApiUser bankApiUser, OnlineBankingService onlineBankingService, BankEntity bankEntity, MultibankingException e) {
        if (e.getMultibankingError() == MultibankingError.INVALID_PIN) {
            bankAccess.setPin(null);
            this.bankAccessRepository.save(bankAccess);
            throw new InvalidPinException(bankAccess.getId());
        }
        if (e.getMultibankingError() == MultibankingError.INVALID_CONSENT) {
            throw new ExternalAuthorisationRequiredException(this.createAvailableAccountsConsent(onlineBankingService, bankApiUser, bankAccess, bankEntity));
        }
        throw e;
    }

    private void checkBankSupported(BankAccessEntity bankAccess, OnlineBankingService onlineBankingService) {
        if (!onlineBankingService.bankSupported(bankAccess.getBankCode())) {
            bankAccess.setStorePin(false);
            bankAccess.setPin(null);
            throw new InvalidBankAccessException(bankAccess.getBankCode());
        }
    }

    private void filterAccounts(BankAccessEntity bankAccess, OnlineBankingService onlineBankingService, List<BankAccount> bankAccounts) {
        List userBankAccounts = this.bankAccountRepository.findByUserId(bankAccess.getUserId());
        Iterator<BankAccount> accountIterator = bankAccounts.iterator();
        while (accountIterator.hasNext()) {
            BankAccount newAccount = accountIterator.next();
            userBankAccounts.stream().filter(bankAccountEntity -> {
                String newAccountExternalID = (String)newAccount.getExternalIdMap().get(onlineBankingService.bankApi());
                String existingAccountExternalID = (String)bankAccountEntity.getExternalIdMap().get(onlineBankingService.bankApi());
                return newAccountExternalID.equals(existingAccountExternalID);
            }).findFirst().ifPresent(bankAccountEntity -> accountIterator.remove());
        }
        if (bankAccounts.isEmpty()) {
            throw new BankAccessAlreadyExistException();
        }
        bankAccess.setBankName(bankAccounts.get(0).getBankName());
    }

    private Consent toConsent(CreateConsentResponse createConsentResponse) {
        Consent consent = new Consent();
        consent.setConsentId(createConsentResponse.getConsentId());
        consent.setAuthUrl(createConsentResponse.getAuthorisationUrl());
        consent.setScaStatus(ScaStatus.STARTED);
        return consent;
    }

    public BankAccountService(BankAccessRepositoryIf bankAccessRepository, BankAccountRepositoryIf bankAccountRepository, OnlineBankingServiceProducer bankingServiceProducer, UserService userService, BankService bankService, Principal principal, FinTSProductConfig finTSProductConfig) {
        this.bankAccessRepository = bankAccessRepository;
        this.bankAccountRepository = bankAccountRepository;
        this.bankingServiceProducer = bankingServiceProducer;
        this.userService = userService;
        this.bankService = bankService;
        this.principal = principal;
        this.finTSProductConfig = finTSProductConfig;
    }
}

