/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.exception;

import de.adorsys.multibanking.domain.Consent;
import de.adorsys.multibanking.exception.ParametrizedMessageException;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

@ResponseStatus(value=HttpStatus.BAD_REQUEST, code=HttpStatus.BAD_REQUEST, reason="AUTHORISE_CONSENT")
public class ExternalAuthorisationRequiredException
extends ParametrizedMessageException {
    private final Consent consent;

    public ExternalAuthorisationRequiredException(Consent consent) {
        super("Consent authorisation required");
        this.addParam("authUrl", consent.getAuthUrl());
        this.consent = consent;
    }

    public Consent getConsent() {
        return this.consent;
    }

    public String toString() {
        return "ExternalAuthorisationRequiredException(consent=" + this.getConsent() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExternalAuthorisationRequiredException)) {
            return false;
        }
        ExternalAuthorisationRequiredException other = (ExternalAuthorisationRequiredException)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Consent this$consent = this.getConsent();
        Consent other$consent = other.getConsent();
        return !(this$consent == null ? other$consent != null : !this$consent.equals(other$consent));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExternalAuthorisationRequiredException;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Consent $consent = this.getConsent();
        result = result * 59 + ($consent == null ? 43 : $consent.hashCode());
        return result;
    }
}

