/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.config;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import de.adorsys.multibanking.web.UserResource;
import java.util.Arrays;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.http.ResponseEntity;
import springfox.documentation.RequestHandler;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.AuthorizationCodeGrantBuilder;
import springfox.documentation.builders.OAuthBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.AuthorizationCodeGrant;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.service.TokenEndpoint;
import springfox.documentation.service.TokenRequestEndpoint;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger.web.SecurityConfiguration;
import springfox.documentation.swagger.web.SecurityConfigurationBuilder;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
@Profile(value={"swagger"})
public class SwaggerConfig {
    private final Environment environment;
    @Value(value="${idp.baseUrl}")
    private String loginUrl;
    @Value(value="${info.project.version}")
    private String version;
    @Value(value="${swagger.client.id:multibanking-client}")
    private String swaggerClientId;
    @Value(value="${idp.realm:multibanking}")
    private String realm;

    @Bean
    public Docket api() {
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).select().apis(this.apis()).paths(PathSelectors.any()).build().useDefaultResponseMessages(false).directModelSubstitute(ResponseEntity.class, Void.class).securitySchemes(Collections.singletonList(this.securityScheme())).securityContexts(Collections.singletonList(this.securityContext()));
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title("Multibanking REST Api").description("Use a bank code (blz) ending with X00 000 00 like 300 000 00 to run aggainst the mock backend. Find the mock backend at ${hostname}:10010").contact(new Contact("Alexander Geist adorsys GmbH & Co. KG", null, "age@adorsys.de")).version(this.version).build();
    }

    private Predicate<RequestHandler> apis() {
        Predicate mbResourses = RequestHandlerSelectors.withClassAnnotation(UserResource.class);
        if (this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"smartanalytics-embedded"}))) {
            return Predicates.or((Predicate)mbResourses, (Predicate)RequestHandlerSelectors.basePackage((String)"de.adorsys.smartanalytics.web"));
        }
        return mbResourses;
    }

    private SecurityContext securityContext() {
        return SecurityContext.builder().securityReferences(Collections.singletonList(new SecurityReference("multibanking_auth", this.scopes()))).forPaths(PathSelectors.any()).build();
    }

    @Bean
    public SecurityConfiguration security() {
        return SecurityConfigurationBuilder.builder().clientId(this.swaggerClientId).build();
    }

    private SecurityScheme securityScheme() {
        String tokenEndpoint = String.format("%s/auth/realms/%s/protocol/openid-connect/token", this.loginUrl, this.realm);
        String tokenRequestEndpoint = String.format("%s/auth/realms/%s/protocol/openid-connect/auth", this.loginUrl, this.realm);
        AuthorizationCodeGrant grantType = new AuthorizationCodeGrantBuilder().tokenEndpoint(new TokenEndpoint(tokenEndpoint, "token")).tokenRequestEndpoint(new TokenRequestEndpoint(tokenRequestEndpoint, this.swaggerClientId, null)).build();
        return new OAuthBuilder().name("multibanking_auth").grantTypes(Collections.singletonList(grantType)).scopes(Arrays.asList(this.scopes())).build();
    }

    private AuthorizationScope[] scopes() {
        return new AuthorizationScope[]{new AuthorizationScope("openid", "openid connect")};
    }

    public SwaggerConfig(Environment environment) {
        this.environment = environment;
    }
}

