/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.web.payment;

import de.adorsys.multibanking.domain.BankAccessEntity;
import de.adorsys.multibanking.domain.BankAccountEntity;
import de.adorsys.multibanking.domain.SinglePaymentEntity;
import de.adorsys.multibanking.domain.UserData;
import de.adorsys.multibanking.exception.ResourceNotFoundException;
import de.adorsys.multibanking.service.BankAccountService;
import de.adorsys.multibanking.service.PaymentService;
import de.adorsys.multibanking.service.UserDataService;
import de.adorsys.multibanking.web.annotation.UserResource;
import de.adorsys.multibanking.web.common.BaseController;
import domain.SinglePayment;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@UserResource
@RestController
@RequestMapping(path={"/api/v1/bankaccesses/{accessId}/accounts/{accountId}/payments"})
@Api(value="/api/v1/bankaccesses/{accessId}/accounts/{accountId}/payments", tags={"MB-007 - Payments"}, description="Initiates and manages payments on behalves of the user.")
public class PaymentController
extends BaseController {
    public static final String BASE_PATH = "/api/v1/bankaccesses/{accessId}/accounts/{accountId}/payments";
    @Autowired
    private BankAccountService bankAccountService;
    @Autowired
    private PaymentService paymentService;
    @Autowired
    private UserDataService uds;

    @RequestMapping(value={"/{paymentId}"}, method={RequestMethod.GET})
    public Resource<SinglePaymentEntity> getPayment(@PathVariable String accessId, @PathVariable String accountId, @PathVariable String paymentId) {
        SinglePaymentEntity paymentEntity = this.paymentService.findPayment(accessId, accountId, paymentId).orElseThrow(() -> new ResourceNotFoundException(SinglePaymentEntity.class, paymentId));
        return this.mapToResource(accessId, accountId, paymentEntity);
    }

    @RequestMapping(method={RequestMethod.POST})
    public HttpEntity<Void> createPayment(@PathVariable String accessId, @PathVariable String accountId, @RequestBody CreatePaymentRequest paymentRequest) {
        UserData userData = this.uds.load();
        BankAccessEntity bankAccessEntity = userData.bankAccessDataOrException(accessId).getBankAccess();
        BankAccountEntity bankAccountEntity = userData.bankAccountDataOrException(accessId, accountId).getBankAccount();
        SinglePaymentEntity payment = this.paymentService.createPayment(bankAccessEntity, bankAccountEntity, paymentRequest.getPin(), paymentRequest.getPayment());
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(ControllerLinkBuilder.linkTo(((PaymentController)ControllerLinkBuilder.methodOn(PaymentController.class, (Object[])new Object[0])).getPayment(accessId, accountId, payment.getId())).toUri());
        return new ResponseEntity((MultiValueMap)headers, HttpStatus.CREATED);
    }

    @RequestMapping(value={"/{paymentId}/submit"}, method={RequestMethod.POST})
    public HttpEntity<Void> submitPayment(@PathVariable String accessId, @PathVariable String accountId, @PathVariable String paymentId, @RequestBody SubmitPaymentRequest paymentRequest) {
        if (!this.bankAccountService.exists(accessId, accountId)) {
            throw new ResourceNotFoundException(BankAccountEntity.class, accountId);
        }
        SinglePaymentEntity paymentEntity = this.paymentService.findPayment(accessId, accountId, paymentId).orElseThrow(() -> new ResourceNotFoundException(SinglePaymentEntity.class, paymentId));
        String bankCode = this.uds.load().bankAccessDataOrException(accessId).getBankAccess().getBankCode();
        this.paymentService.submitPayment(paymentEntity, bankCode, paymentRequest.getTan());
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    private Resource<SinglePaymentEntity> mapToResource(@PathVariable String accessId, @PathVariable String accountId, SinglePaymentEntity paymentEntity) {
        return new Resource((Object)paymentEntity, new Link[]{ControllerLinkBuilder.linkTo(((PaymentController)ControllerLinkBuilder.methodOn(PaymentController.class, (Object[])new Object[0])).getPayment(accessId, accountId, paymentEntity.getId())).withSelfRel()});
    }

    private static class SubmitPaymentRequest {
        String tan;

        public String getTan() {
            return this.tan;
        }

        public void setTan(String tan) {
            this.tan = tan;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SubmitPaymentRequest)) {
                return false;
            }
            SubmitPaymentRequest other = (SubmitPaymentRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$tan = this.getTan();
            String other$tan = other.getTan();
            return !(this$tan == null ? other$tan != null : !this$tan.equals(other$tan));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SubmitPaymentRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $tan = this.getTan();
            result = result * 59 + ($tan == null ? 43 : $tan.hashCode());
            return result;
        }

        public String toString() {
            return "PaymentController.SubmitPaymentRequest(tan=" + this.getTan() + ")";
        }
    }

    private static class CreatePaymentRequest {
        SinglePayment payment;
        String pin;

        public SinglePayment getPayment() {
            return this.payment;
        }

        public String getPin() {
            return this.pin;
        }

        public void setPayment(SinglePayment payment) {
            this.payment = payment;
        }

        public void setPin(String pin) {
            this.pin = pin;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreatePaymentRequest)) {
                return false;
            }
            CreatePaymentRequest other = (CreatePaymentRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SinglePayment this$payment = this.getPayment();
            SinglePayment other$payment = other.getPayment();
            if (this$payment == null ? other$payment != null : !this$payment.equals(other$payment)) {
                return false;
            }
            String this$pin = this.getPin();
            String other$pin = other.getPin();
            return !(this$pin == null ? other$pin != null : !this$pin.equals(other$pin));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CreatePaymentRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SinglePayment $payment = this.getPayment();
            result = result * 59 + ($payment == null ? 43 : $payment.hashCode());
            String $pin = this.getPin();
            result = result * 59 + ($pin == null ? 43 : $pin.hashCode());
            return result;
        }

        public String toString() {
            return "PaymentController.CreatePaymentRequest(payment=" + this.getPayment() + ", pin=" + this.getPin() + ")";
        }
    }
}

