/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.web.common;

import de.adorsys.multibanking.domain.BankAccountData;
import de.adorsys.multibanking.exception.SyncInProgressException;
import domain.BankAccount;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(SynchChecker.class);

    public static void checkSynch(BankAccountData accountData) {
        if (accountData.getSyncStatusTime() == null) {
            return;
        }
        if (accountData.getBankAccount().getSyncStatus() == BankAccount.SyncStatus.READY) {
            return;
        }
        if (accountData.getBankAccount().getSyncStatus() == BankAccount.SyncStatus.SYNC) {
            throw new SyncInProgressException(accountData.getBankAccount().getBankAccessId(), accountData.getBankAccount().getId());
        }
        if (accountData.getBankAccount().getSyncStatus() == BankAccount.SyncStatus.PENDING) {
            LOGGER.warn("The synch status pending is not expected in this application. We will allow synch to go on.");
        }
    }
}

