/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.web.account;

import de.adorsys.multibanking.exception.domain.MultibankingError;
import de.adorsys.multibanking.service.BookingService;
import de.adorsys.multibanking.web.annotation.UserResource;
import de.adorsys.multibanking.web.common.BankAccountBasedController;
import domain.BankApi;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@UserResource
@RestController
@RequestMapping(path={"/api/v1/bankaccesses/{accessId}/accounts"})
@Api(value="/api/v1/bankaccesses/{accessId}/accounts", tags={"MB-005 - Bank Accounts"}, description="Manages access to a single bank account. Does not allow reading a single bank account data. Bank account information are contained in the user data object.")
public class BankAccountController
extends BankAccountBasedController {
    public static final String BASE_PATH = "/api/v1/bankaccesses/{accessId}/accounts";
    private static final String SYNC_SEGMENT = "/{accountId}/sync";
    public static final String SYNC_PATH = "/api/v1/bankaccesses/{accessId}/accounts/{accountId}/sync";
    @Autowired
    private BookingService bookingService;

    @RequestMapping(path={"/{accountId}/sync"}, method={RequestMethod.PUT})
    @ApiOperation(value="Synchronize bookings", notes="Synchronize the user booking with the remote bank account. Generally load all new booking since the last synch. Uses the booking date to splitt and store bookings into configured booking periods files e.g. yearly, quaterly. Will generally return a 204 for a sucessful request. Will return a 102 if another synch is in progress.")
    @ApiResponses(value={@ApiResponse(code=204, message="Bank account with provided id successfuly setup for synchronization"), @ApiResponse(code=401, message="user.unauthenticated : User not authenticated", response=MultibankingError.class), @ApiResponse(code=412, message="User with Id [{1}] not found. First create the user.", response=MultibankingError.class), @ApiResponse(code=404, message="Resource [{0}] with id [{1}] not found.", response=MultibankingError.class), @ApiResponse(code=102, message="Sync in progress for account with accessId [{0}] and accountId [{1}].", response=MultibankingError.class), @ApiResponse(code=403, message="credential.invalid: Credentials not valid for provided bank code", response=MultibankingError.class), @ApiResponse(code=400, message="Invalid request. See response content.", response=MultibankingError.class)})
    public HttpEntity<Void> syncBookings(@ApiParam(name="accessId", required=true, value="The identifier of the bank access container the bank account.", example="3c149076-13c4-4190-ace3-e30bf8f61526") @PathVariable String accessId, @ApiParam(name="accountId", required=true, value="The identifier of the bank account in the scope of the containing bank access.", example="DE81199999993528307800") @PathVariable String accountId, @ApiParam(name="pin", required=false, value="The password of the corresponding online banking account, in case this was not saved on the server", example="12345") @RequestBody(required=false) String pin) {
        this.checkBankAccountExists(accessId, accountId);
        this.checkSynch(accessId, accountId);
        BankApi bankApi = null;
        this.bookingService.syncBookings(accessId, accountId, bankApi, pin);
        return new ResponseEntity((MultiValueMap)this.userDataLocationHeader(), HttpStatus.NO_CONTENT);
    }
}

