/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service.helper;

import com.fasterxml.jackson.core.type.TypeReference;
import de.adorsys.multibanking.domain.RuleEntity;
import de.adorsys.multibanking.service.base.CacheBasedService;
import de.adorsys.multibanking.service.base.ListUtils;
import de.adorsys.multibanking.service.helper.RuleUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.adorsys.docusafe.business.DocumentSafeService;
import org.adorsys.docusafe.business.types.complex.DSDocument;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BookingRuleServiceTemplate<T extends RuleEntity> {
    @Autowired
    private DocumentSafeService documentSafeService;

    protected abstract CacheBasedService cbs();

    protected abstract TypeReference<List<T>> listType();

    public DSDocument getBookingRules() {
        return this.documentSafeService.readDocument(this.cbs().auth(), RuleUtils.bookingRulesFQN);
    }

    public void createOrUpdateRule(T ruleEntity) {
        this.createOrUpdateRules(Collections.singletonList(ruleEntity));
    }

    public void createOrUpdateRules(List<T> ruleEntities) {
        List<T> persList = this.cbs().load(RuleUtils.bookingRulesFQN, this.listType()).orElse(new ArrayList());
        persList = ListUtils.updateList(RuleUtils.normalize(ruleEntities), persList);
        this.cbs().store(RuleUtils.bookingRulesFQN, this.listType(), persList);
    }

    public void replaceRules(List<T> ruleEntities) {
        ruleEntities = ListUtils.setId(ruleEntities);
        this.cbs().store(RuleUtils.bookingRulesFQN, this.listType(), ruleEntities);
    }

    public boolean deleteRule(String ruleId) {
        return this.deleteRules(Collections.singletonList(ruleId));
    }

    public boolean deleteRules(List<String> ruleIds) {
        List persList = this.cbs().load(RuleUtils.bookingRulesFQN, this.listType()).orElse(new ArrayList());
        List newPersList = ListUtils.deleteListById(ruleIds, persList);
        this.cbs().store(RuleUtils.bookingRulesFQN, this.listType(), newPersList);
        return newPersList.size() - persList.size() != 0;
    }

    public List<T> loadRules() {
        return this.cbs().load(RuleUtils.bookingRulesFQN, this.listType()).orElse(new ArrayList());
    }
}

