/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service;

import com.fasterxml.jackson.core.type.TypeReference;
import de.adorsys.multibanking.domain.BankAccessEntity;
import de.adorsys.multibanking.domain.BankAccountEntity;
import de.adorsys.multibanking.domain.BankEntity;
import de.adorsys.multibanking.domain.SinglePaymentEntity;
import de.adorsys.multibanking.exception.MissingPinException;
import de.adorsys.multibanking.exception.PaymentException;
import de.adorsys.multibanking.exception.ResourceNotFoundException;
import de.adorsys.multibanking.service.BankService;
import de.adorsys.multibanking.service.UserDataService;
import de.adorsys.multibanking.service.base.ListUtils;
import de.adorsys.multibanking.service.base.UserObjectService;
import de.adorsys.multibanking.service.producer.OnlineBankingServiceProducer;
import de.adorsys.multibanking.utils.FQNUtils;
import domain.AbstractPayment;
import domain.BankAccess;
import domain.BankApiUser;
import domain.PaymentRequest;
import domain.SinglePayment;
import domain.request.SubmitPaymentRequest;
import exception.HbciException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import spi.OnlineBankingService;

@Service
public class PaymentService {
    @Autowired
    private UserObjectService uos;
    @Autowired
    private OnlineBankingServiceProducer bankingServiceProducer;
    @Autowired
    private UserDataService uds;
    @Autowired
    private BankService bankService;

    private static DocumentFQN paymentsFQN(SinglePaymentEntity target) {
        return FQNUtils.paymentsFQN(target.getBankAccessId(), target.getBankAccountId());
    }

    private static TypeReference<List<SinglePaymentEntity>> listType() {
        return new TypeReference<List<SinglePaymentEntity>>(){};
    }

    public SinglePaymentEntity createPayment(BankAccessEntity bankAccess, BankAccountEntity bankAccount, String pin, SinglePayment payment) {
        OnlineBankingService bankingService = this.bankingServiceProducer.getBankingService(bankAccess.getBankCode());
        BankApiUser bankApiUser = this.uds.checkApiRegistration(bankingService.bankApi(), bankAccess);
        String string = pin = pin == null ? bankAccess.getPin() : pin;
        if (pin == null) {
            throw new MissingPinException();
        }
        BankEntity bankEntity = this.bankService.findByBankCode(bankAccess.getBankCode()).orElseThrow(() -> new ResourceNotFoundException(BankEntity.class, bankAccess.getBankCode()));
        try {
            Object tanSubmit = bankingService.createPayment(Optional.ofNullable(bankEntity.getBankingUrl()), PaymentRequest.builder().bankApiUser(bankApiUser).payment((AbstractPayment)payment).bankAccess((BankAccess)bankAccess).pin(pin).bankCode(bankEntity.getBlzHbci()).build());
            SinglePaymentEntity pe = new SinglePaymentEntity();
            BeanUtils.copyProperties((Object)payment, (Object)pe);
            pe.setUserId(bankAccess.getUserId());
            pe.setSenderAccountNumber(bankAccount.getAccountNumber());
            pe.setSenderIban(bankAccount.getIban());
            pe.setSenderBic(bankAccount.getBic());
            pe.setCreatedDateTime(new Date());
            pe.setBankAccessId(bankAccess.getId());
            pe.setBankAccountId(bankAccount.getId());
            pe.setTanSubmitExternal(tanSubmit);
            this.create(pe);
            return pe;
        }
        catch (HbciException e) {
            throw new PaymentException(e.getMessage());
        }
    }

    public void submitPayment(SinglePaymentEntity paymentEntity, String bankCode, String tan) {
        OnlineBankingService bankingService = this.bankingServiceProducer.getBankingService(bankCode);
        SubmitPaymentRequest submitPaymentRequest = SubmitPaymentRequest.builder().payment((AbstractPayment)paymentEntity).tanSubmit(paymentEntity.getTanSubmitExternal()).tan(tan).build();
        try {
            bankingService.submitPayment(Optional.empty(), submitPaymentRequest);
        }
        catch (HbciException e) {
            throw new PaymentException(e.getMessage());
        }
        this.delete(paymentEntity);
    }

    public Optional<SinglePaymentEntity> findPayment(String accessId, String accountId, String paymentId) {
        List persList = this.uos.load(FQNUtils.paymentsFQN(accessId, accountId), PaymentService.listType()).orElse(Collections.emptyList());
        return ListUtils.find(paymentId, persList);
    }

    private void create(SinglePaymentEntity payment) {
        List<Object> persList = this.uos.load(PaymentService.paymentsFQN(payment), PaymentService.listType()).orElse(Collections.emptyList());
        persList = ListUtils.updateList(Collections.singletonList(payment), persList);
        this.uos.store(PaymentService.paymentsFQN(payment), PaymentService.listType(), persList);
    }

    private boolean delete(SinglePaymentEntity payment) {
        List persList = this.uos.load(PaymentService.paymentsFQN(payment), PaymentService.listType()).orElse(Collections.emptyList());
        List<SinglePaymentEntity> newPersList = ListUtils.deleteList(Collections.singletonList(payment), persList);
        this.uos.store(PaymentService.paymentsFQN(payment), PaymentService.listType(), persList);
        return persList.size() - newPersList.size() != 0;
    }
}

