/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.service;

import com.fasterxml.jackson.core.type.TypeReference;
import de.adorsys.multibanking.domain.BankAccessCredentials;
import de.adorsys.multibanking.exception.ResourceNotFoundException;
import de.adorsys.multibanking.service.base.UserObjectService;
import de.adorsys.multibanking.utils.FQNUtils;
import java.util.Date;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BankAccessCredentialService {
    @Autowired
    private UserObjectService uos;

    public void store(BankAccessCredentials credentials) {
        this.uos.store(FQNUtils.credentialFQN(credentials.getAccessId()), BankAccessCredentialService.credentialsType(), credentials);
    }

    public void setInvalidPin(String accessId) {
        DocumentFQN credentialsFQN = FQNUtils.credentialFQN(accessId);
        BankAccessCredentials credentials = this.uos.load(credentialsFQN, BankAccessCredentialService.credentialsType()).orElseThrow(() -> new ResourceNotFoundException(BankAccessCredentials.class, accessId));
        this.invalidate(credentials);
    }

    public BankAccessCredentials loadCredentials(String accessId) {
        return this.uos.load(FQNUtils.credentialFQN(accessId), BankAccessCredentialService.credentialsType()).orElseThrow(() -> new ResourceNotFoundException(BankAccessCredentials.class, accessId));
    }

    public void invalidate(BankAccessCredentials credentials) {
        DocumentFQN credentialsFQN = FQNUtils.credentialFQN(credentials.getAccessId());
        credentials.setPinValid(false);
        credentials.setLastValidationDate(new Date());
        this.uos.store(credentialsFQN, BankAccessCredentialService.credentialsType(), credentials);
    }

    private static TypeReference<BankAccessCredentials> credentialsType() {
        return new TypeReference<BankAccessCredentials>(){};
    }
}

