/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.domain;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.adorsys.cryptoutils.exceptions.BaseException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.format.datetime.standard.DateTimeFormatterFactory;

public enum BookingFilePeriod {
    ALL{

        @Override
        public String marker(LocalDate date) {
            return "all";
        }
    }
    ,
    YEAR{

        @Override
        public String marker(LocalDate date) {
            return 2.yearMarker(date);
        }
    }
    ,
    SEMESTER{

        @Override
        public String marker(LocalDate date) {
            return BookingFilePeriod.semesterMarker(date);
        }
    }
    ,
    QUATER{

        @Override
        public String marker(LocalDate date) {
            return BookingFilePeriod.quarterMaker(date);
        }
    }
    ,
    MONTH{

        @Override
        public String marker(LocalDate date) {
            return BookingFilePeriod.monthMarker(date);
        }
    }
    ,
    WEEK{

        @Override
        public String marker(LocalDate date) {
            return BookingFilePeriod.weekMaker(date);
        }
    }
    ,
    DAY{

        @Override
        public String marker(LocalDate date) {
            return BookingFilePeriod.dayMarker(date);
        }
    };

    private static final String YEAR_FORMAT = "yyyy";
    private static final DateTimeFormatter yearFormater;
    private static final String MONTH_FORMAT = "yyyy'M'MM";
    private static final DateTimeFormatter monthFormater;
    private static final String WEEK_FORMAT = "YYYY'W'ww";
    private static final DateTimeFormatter weekFormater;
    private static final String DAY_FORMAT = "yyyyMMdd";
    private static final DateTimeFormatter dayFormater;

    public abstract String marker(LocalDate var1);

    public static final String yearMarker(LocalDate date) {
        return date.format(yearFormater);
    }

    private static final String semesterMarker(LocalDate date) {
        String year = date.format(yearFormater);
        if (date.getMonthValue() < 7) {
            return year + "S1";
        }
        return year + "S2";
    }

    private static final String quarterMaker(LocalDate date) {
        String year = date.format(yearFormater);
        switch (date.getMonthValue()) {
            case 1: 
            case 2: 
            case 3: {
                return year + "Q1";
            }
            case 4: 
            case 5: 
            case 6: {
                return year + "Q2";
            }
            case 7: 
            case 8: 
            case 9: {
                return year + "Q3";
            }
            case 10: 
            case 11: 
            case 12: {
                return year + "Q4";
            }
        }
        throw new BaseException("Illegal month digit: > 12 or < 1");
    }

    private static final String monthMarker(LocalDate date) {
        return date.format(monthFormater);
    }

    private static final String weekMaker(LocalDate date) {
        int dayOfYear = date.getDayOfYear();
        int week = dayOfYear / 7;
        int cw = 1 + date.getDayOfYear() / 7;
        String year = date.format(yearFormater);
        return year + "W" + StringUtils.leftPad((String)(cw + ""), (int)2, (char)'0');
    }

    private static final String dayMarker(LocalDate date) {
        return date.format(dayFormater);
    }

    static {
        yearFormater = new DateTimeFormatterFactory(YEAR_FORMAT).createDateTimeFormatter();
        monthFormater = new DateTimeFormatterFactory(MONTH_FORMAT).createDateTimeFormatter();
        weekFormater = new DateTimeFormatterFactory(WEEK_FORMAT).createDateTimeFormatter();
        dayFormater = new DateTimeFormatterFactory(DAY_FORMAT).createDateTimeFormatter();
    }
}

